/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.cryptography.implementation;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.demoiselle.signer.cryptography.CryptographyException;
import org.demoiselle.signer.cryptography.Digest;
import org.demoiselle.signer.cryptography.DigestAlgorithmEnum;
import org.demoiselle.signer.cryptography.util.MessagesBundle;

public class DigestImpl
implements Digest {
    private String algorithm = DigestAlgorithmEnum.DEFAULT.getAlgorithm();
    private final int BUFSIZE = 256;
    private static MessagesBundle crytographyMessagesBundle = new MessagesBundle("messages_cryptography");

    @Override
    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    @Override
    public byte[] digest(byte[] content) {
        byte[] result = null;
        if (this.algorithm == null) {
            this.algorithm = DigestAlgorithmEnum.DEFAULT.getAlgorithm();
        }
        if (content == null) {
            throw new CryptographyException(crytographyMessagesBundle.getString("error.content.null"));
        }
        try {
            MessageDigest digest = MessageDigest.getInstance(this.algorithm);
            digest.update(content);
            result = digest.digest();
        }
        catch (Throwable error) {
            throw new CryptographyException(crytographyMessagesBundle.getString("error.digest.generate"), error);
        }
        return result;
    }

    @Override
    public byte[] digestFile(File file) {
        try {
            MessageDigest md = MessageDigest.getInstance(this.algorithm);
            FileInputStream fileIS = new FileInputStream(file);
            BufferedInputStream bis = new BufferedInputStream(fileIS);
            DataInputStream dis = new DataInputStream(bis);
            DigestInputStream digin = new DigestInputStream(dis, md);
            byte[] buffer = new byte[256];
            while (digin.read(buffer, 0, 256) != -1) {
            }
            digin.close();
            return md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptographyException(crytographyMessagesBundle.getString("error.set.algorithm"), e);
        }
        catch (FileNotFoundException e) {
            throw new CryptographyException(crytographyMessagesBundle.getString("error.file.not.found", file), e);
        }
        catch (IOException e) {
            throw new CryptographyException(crytographyMessagesBundle.getString("error.reading.file", file), e);
        }
    }

    @Override
    public String digestFileHex(File file) {
        byte[] bytes = this.digestFile(file);
        String hex = this.convertToHex(bytes);
        return hex;
    }

    @Override
    public String digestHex(byte[] content) {
        byte[] bytes = this.digest(content);
        String hex = this.convertToHex(bytes);
        return hex;
    }

    private String convertToHex(byte[] data) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            int halfbyte = data[i] >>> 4 & 0xF;
            int two_halfs = 0;
            do {
                if (0 <= halfbyte && halfbyte <= 9) {
                    buf.append((char)(48 + halfbyte));
                } else {
                    buf.append((char)(97 + (halfbyte - 10)));
                }
                halfbyte = data[i] & 0xF;
            } while (two_halfs++ < 1);
        }
        return buf.toString();
    }

    @Override
    public void setAlgorithm(DigestAlgorithmEnum algorithm) {
        this.setAlgorithm(algorithm.getAlgorithm());
    }
}

