/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.timestamp;

import java.security.PrivateKey;
import java.security.cert.Certificate;
import org.demoiselle.signer.core.Priority;
import org.demoiselle.signer.core.exception.CertificateCoreException;
import org.demoiselle.signer.core.timestamp.TimeStampGenerator;
import org.demoiselle.signer.core.util.MessagesBundle;
import org.demoiselle.signer.timestamp.configuration.TimeStampConfig;
import org.demoiselle.signer.timestamp.connector.TimeStampOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Priority(value=0x7FFFFFFF)
public class TimestampGeneratorImpl
implements TimeStampGenerator {
    private static final Logger logger = LoggerFactory.getLogger(TimestampGeneratorImpl.class);
    private static final MessagesBundle timeStampMessagesBundle = new MessagesBundle();
    private byte[] content = null;
    private PrivateKey privateKey;
    private Certificate[] certificates;
    private byte[] hash = null;

    public void initialize(byte[] content, PrivateKey privateKey, Certificate[] certificates, byte[] hash) throws CertificateCoreException {
        this.content = content;
        this.privateKey = privateKey;
        this.certificates = certificates;
        this.hash = hash;
    }

    public byte[] generateTimeStamp() throws CertificateCoreException {
        byte[] resp = null;
        int attempt = 1;
        while (attempt <= TimeStampConfig.getInstance().getConnectReplay()) {
            try {
                logger.debug(timeStampMessagesBundle.getString("info.timestamp.attempt", new Object[]{attempt}));
                TimeStampOperator timeStampOperator = new TimeStampOperator();
                byte[] request = timeStampOperator.createRequest(this.privateKey, this.certificates, this.content, this.hash);
                resp = timeStampOperator.invoke(request);
                if (resp == null) continue;
                break;
            }
            catch (CertificateCoreException e) {
                ++attempt;
            }
        }
        if (resp != null && resp.length > 1) {
            logger.debug(timeStampMessagesBundle.getString("info.timestamp.attempt", new Object[]{attempt}));
            return resp;
        }
        logger.error(timeStampMessagesBundle.getString("info.timestamp.attempt.exceeded", new Object[]{attempt}));
        throw new CertificateCoreException(timeStampMessagesBundle.getString("info.timestamp.attempt.exceeded", new Object[]{attempt}));
    }

    public void validateTimeStamp(byte[] content, byte[] timestamp, byte[] hash) throws CertificateCoreException {
        TimeStampOperator timeStampOperator = new TimeStampOperator();
        timeStampOperator.validate(content, timestamp, hash);
    }
}

