/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.timestamp.configuration;

import org.demoiselle.signer.core.util.MessagesBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeStampConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimeStampConfig.class);
    private static MessagesBundle timeStampMessagesBundle = new MessagesBundle();
    public static final String TIMESTAMP_TIMEOUT = "signer.timestamp.timeout";
    public static final String ENV_TIMESTAMP_TIMEOUT = "SIGNER_TIMESTAMP_TIMEOUT";
    public static final String TIMESTAMP_CONNECT_REPLAY = "signer.timestamp.connect_replay";
    public static final String ENV_TIMESTAMP_CONNECT_REPLAY = "SIGNER_TIMESTAMP_CONNECT_REPLAY";
    public static TimeStampConfig instance = new TimeStampConfig();
    private int timeOut = 30000;
    private int connectReplay = 3;

    public static TimeStampConfig getInstance() {
        if (instance == null) {
            instance = new TimeStampConfig();
        }
        return instance;
    }

    private TimeStampConfig() {
        try {
            String varTimeOut = System.getenv(ENV_TIMESTAMP_TIMEOUT);
            if (varTimeOut == null || varTimeOut.isEmpty()) {
                varTimeOut = (String)System.getProperties().get(TIMESTAMP_TIMEOUT);
                if (varTimeOut == null || varTimeOut.isEmpty()) {
                    LOGGER.debug("DEFAULT");
                    LOGGER.debug(timeStampMessagesBundle.getString("info.timestamp.timeout.value", new Object[]{this.getTimeOut()}));
                } else {
                    LOGGER.debug("key");
                    this.setTimeOut(Integer.valueOf(varTimeOut));
                }
            } else {
                LOGGER.debug("ENV");
                this.setTimeOut(Integer.valueOf(varTimeOut));
            }
        }
        catch (Exception e) {
            LOGGER.debug(timeStampMessagesBundle.getString("info.timestamp.timeout.value", new Object[]{this.getTimeOut()}));
        }
        try {
            String varConnectReplay = System.getenv(ENV_TIMESTAMP_CONNECT_REPLAY);
            if (varConnectReplay == null || varConnectReplay.isEmpty()) {
                varConnectReplay = (String)System.getProperties().get(TIMESTAMP_CONNECT_REPLAY);
                if (varConnectReplay == null || varConnectReplay.isEmpty()) {
                    LOGGER.debug("DEFAULT");
                    LOGGER.debug(timeStampMessagesBundle.getString("info.timestamp.connect.replay.value", new Object[]{this.getConnectReplay()}));
                } else {
                    LOGGER.debug("key");
                    this.setConnectReplay(Integer.valueOf(varConnectReplay));
                }
            } else {
                LOGGER.debug("ENV");
                this.setConnectReplay(Integer.valueOf(varConnectReplay));
            }
        }
        catch (Exception e) {
            LOGGER.debug(timeStampMessagesBundle.getString("info.timestamp.connect.replay.value", new Object[]{this.getConnectReplay()}));
        }
    }

    public int getTimeOut() {
        return this.timeOut;
    }

    public void setTimeOut(int parmTimeOut) {
        this.timeOut = parmTimeOut;
        LOGGER.debug(timeStampMessagesBundle.getString("info.timestamp.timeout.value", new Object[]{this.getTimeOut()}));
    }

    public int getConnectReplay() {
        return this.connectReplay;
    }

    public void setConnectReplay(int connectReplay) {
        this.connectReplay = connectReplay;
        LOGGER.debug(timeStampMessagesBundle.getString("info.timestamp.connect.replay.value", new Object[]{this.getConnectReplay()}));
    }
}

