/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.timestamp.connector;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.demoiselle.signer.core.util.MessagesBundle;
import org.demoiselle.signer.timestamp.connector.Connector;
import org.demoiselle.signer.timestamp.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketConnector
implements Connector {
    private static final Logger logger = LoggerFactory.getLogger(SocketConnector.class);
    private static MessagesBundle timeStampMessagesBundle = new MessagesBundle();
    private String hostname = "";
    private int port;
    private OutputStream out = null;
    private Socket socket = null;

    @Override
    public InputStream connect(byte[] content) {
        try {
            logger.info(timeStampMessagesBundle.getString("info.timestamp.send.request"));
            this.socket = new Socket(this.hostname, this.port);
            logger.info(timeStampMessagesBundle.getString("info.timestamp.connected", new Object[]{this.socket.isConnected(), this.hostname, this.port}));
            logger.info(timeStampMessagesBundle.getString("info.timestamp.socket.write"));
            this.out = this.socket.getOutputStream();
            this.out.write(Utils.intToByteArray(1 + content.length));
            this.out.write(0);
            this.out.write(content);
            this.out.flush();
            logger.info(timeStampMessagesBundle.getString("info.timestamp.socket.response"));
            return this.socket.getInputStream();
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.info(e.getMessage());
            return null;
        }
    }

    @Override
    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    @Override
    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public void close() {
        try {
            this.socket.close();
            this.out.close();
        }
        catch (IOException ex) {
            logger.info(ex.getMessage());
        }
    }
}

