/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.timestamp.connector;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.tsp.TSPAlgorithms;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TimeStampRequest;
import org.bouncycastle.tsp.TimeStampRequestGenerator;
import org.bouncycastle.tsp.TimeStampResponse;
import org.bouncycastle.tsp.TimeStampToken;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;
import org.demoiselle.signer.core.exception.CertificateCoreException;
import org.demoiselle.signer.core.util.MessagesBundle;
import org.demoiselle.signer.cryptography.Digest;
import org.demoiselle.signer.cryptography.DigestAlgorithmEnum;
import org.demoiselle.signer.cryptography.factory.DigestFactory;
import org.demoiselle.signer.timestamp.Timestamp;
import org.demoiselle.signer.timestamp.connector.Connector;
import org.demoiselle.signer.timestamp.connector.ConnectorFactory;
import org.demoiselle.signer.timestamp.enumeration.ConnectionType;
import org.demoiselle.signer.timestamp.signer.RequestSigner;
import org.demoiselle.signer.timestamp.utils.TimeStampConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeStampOperator {
    private static final Logger logger = LoggerFactory.getLogger(TimeStampOperator.class);
    private static MessagesBundle timeStampMessagesBundle = new MessagesBundle();
    private InputStream inputStream = null;
    private Timestamp timestamp;
    private TimeStampRequest timeStampRequest;
    private TimeStampResponse timeStampResponse;

    public byte[] createRequest(PrivateKey privateKey, Certificate[] certificates, byte[] content, byte[] hash) throws CertificateCoreException {
        try {
            logger.info(timeStampMessagesBundle.getString("info.timestamp.digest"));
            Digest digest = DigestFactory.getInstance().factoryDefault();
            digest.setAlgorithm(DigestAlgorithmEnum.SHA_256);
            byte[] hashedMessage = null;
            hashedMessage = content != null ? digest.digest(content) : hash;
            logger.info(timeStampMessagesBundle.getString("info.timestamp.prepare.request"));
            TimeStampRequestGenerator timeStampRequestGenerator = new TimeStampRequestGenerator();
            timeStampRequestGenerator.setReqPolicy(new ASN1ObjectIdentifier(TimeStampConfig.getInstance().getTSPOid()));
            timeStampRequestGenerator.setCertReq(true);
            BigInteger nonce = BigInteger.valueOf(100L);
            this.timeStampRequest = timeStampRequestGenerator.generate(new ASN1ObjectIdentifier(TSPAlgorithms.SHA256.getId()), hashedMessage, nonce);
            byte[] request = this.timeStampRequest.getEncoded();
            logger.info(timeStampMessagesBundle.getString("info.timestamp.sign.request"));
            RequestSigner requestSigner = new RequestSigner();
            byte[] signedRequest = requestSigner.signRequest(privateKey, certificates, request, "SHA256withRSA");
            return signedRequest;
        }
        catch (IOException ex) {
            throw new CertificateCoreException(ex.getMessage());
        }
    }

    public byte[] createRequest(String keystoreLocation, String pin, String alias, byte[] content, byte[] hash) throws CertificateCoreException {
        try {
            KeyStore ks = KeyStore.getInstance("PKCS12");
            ks.load(new FileInputStream(keystoreLocation), pin.toCharArray());
            PrivateKey pk = (PrivateKey)ks.getKey(alias, pin.toCharArray());
            Certificate[] certs = ks.getCertificateChain(alias);
            return this.createRequest(pk, certs, content, hash);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException ex) {
            throw new CertificateCoreException(ex.getMessage());
        }
    }

    public byte[] invoke(byte[] request) throws CertificateCoreException {
        try {
            logger.info(timeStampMessagesBundle.getString("info.timestamp.init.request"));
            Connector connector = ConnectorFactory.buildConnector(ConnectionType.SOCKET);
            connector.setHostname(TimeStampConfig.getInstance().getTspHostname());
            connector.setPort(TimeStampConfig.getInstance().getTSPPort());
            logger.info(timeStampMessagesBundle.getString("info.timestamp.response"));
            this.inputStream = connector.connect(request);
            int timeOut = 3500;
            long tempo = System.currentTimeMillis() + (long)timeOut;
            while (this.inputStream.available() < 4 && System.currentTimeMillis() < tempo) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            byte[] tamanhoRetorno = new byte[4];
            this.inputStream.read(tamanhoRetorno, 0, 4);
            int tamanho = new BigInteger(tamanhoRetorno).intValue();
            if (System.currentTimeMillis() < tempo) {
                while (this.inputStream.available() < tamanho && System.currentTimeMillis() < tempo) {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (System.currentTimeMillis() >= tempo) {
                    logger.error(timeStampMessagesBundle.getString("info.timestamp.timeout"));
                }
            } else {
                logger.error(timeStampMessagesBundle.getString("info.timestamp.timeout"));
            }
            byte[] retornoFlag = new byte[1];
            this.inputStream.read(retornoFlag, 0, 1);
            byte[] retornoCarimboDeTempo = new byte[--tamanho];
            this.inputStream.read(retornoCarimboDeTempo, 0, tamanho);
            this.timeStampResponse = new TimeStampResponse(retornoCarimboDeTempo);
            logger.info(timeStampMessagesBundle.getString("info.timestamp.status", new Object[]{this.timeStampResponse.getStatus()}));
            switch (this.timeStampResponse.getStatus()) {
                case 0: {
                    logger.info(timeStampMessagesBundle.getString("info.pkistatus.granted"));
                    break;
                }
                case 1: {
                    logger.info(timeStampMessagesBundle.getString("info.pkistatus.grantedWithMods"));
                    break;
                }
                case 2: {
                    logger.info(timeStampMessagesBundle.getString("error.pkistatus.rejection"));
                    throw new CertificateCoreException(timeStampMessagesBundle.getString("error.pkistatus.rejection"));
                }
                case 3: {
                    logger.info(timeStampMessagesBundle.getString("error.pkistatus.waiting"));
                    throw new CertificateCoreException(timeStampMessagesBundle.getString("error.pkistatus.waiting"));
                }
                case 4: {
                    logger.info(timeStampMessagesBundle.getString("error.pkistatus.revocation.warn"));
                    throw new CertificateCoreException(timeStampMessagesBundle.getString("error.pkistatus.revocation.warn"));
                }
                case 5: {
                    logger.info(timeStampMessagesBundle.getString("error.pkistatus.revocation.notification"));
                    throw new CertificateCoreException(timeStampMessagesBundle.getString("error.pkistatus.revocation.notification"));
                }
                default: {
                    logger.info(timeStampMessagesBundle.getString("error.pkistatus.unknown"));
                    throw new CertificateCoreException(timeStampMessagesBundle.getString("error.pkistatus.unknown"));
                }
            }
            int failInfo = -1;
            if (this.timeStampResponse.getFailInfo() != null) {
                failInfo = Integer.parseInt(new String(this.timeStampResponse.getFailInfo().getBytes()));
            }
            logger.info(timeStampMessagesBundle.getString("info.timestamp.failinfo", new Object[]{failInfo}));
            switch (failInfo) {
                case 0: {
                    logger.info(timeStampMessagesBundle.getString("error.pkifailureinfo.badAlg"));
                    break;
                }
                case 2: {
                    logger.info(timeStampMessagesBundle.getString("error.pkifailureinfo.badRequest"));
                    break;
                }
                case 5: {
                    logger.info(timeStampMessagesBundle.getString("error.pkifailureinfo.badDataFormat"));
                    break;
                }
                case 14: {
                    logger.info(timeStampMessagesBundle.getString("error.pkifailureinfo.timeNotAvailable"));
                    break;
                }
                case 15: {
                    logger.info(timeStampMessagesBundle.getString("error.pkifailureinfo.unacceptedPolicy"));
                    break;
                }
                case 16: {
                    logger.info(timeStampMessagesBundle.getString("error.pkifailureinfo.unacceptedExtension"));
                    break;
                }
                case 17: {
                    logger.info(timeStampMessagesBundle.getString("error.pkifailureinfo.addInfoNotAvailable"));
                    break;
                }
                case 25: {
                    logger.info(timeStampMessagesBundle.getString("error.pkifailureinfo.systemFailure"));
                }
            }
            this.timeStampResponse.validate(this.timeStampRequest);
            TimeStampToken timeStampToken = this.timeStampResponse.getTimeStampToken();
            this.setTimestamp(new Timestamp(timeStampToken));
            if (timeStampToken == null) {
                throw new CertificateCoreException(timeStampMessagesBundle.getString("error.timestamp.token.null"));
            }
            connector.close();
            logger.info(this.timestamp.toString());
            return this.timestamp.getEncoded();
        }
        catch (IOException | TSPException | CertificateCoreException e) {
            throw new CertificateCoreException(e.getMessage());
        }
    }

    public void validate(byte[] content, byte[] timeStamp, byte[] hash) throws CertificateCoreException {
        try {
            TimeStampToken timeStampToken = new TimeStampToken(new CMSSignedData(timeStamp));
            CMSSignedData s = timeStampToken.toCMSSignedData();
            int verified = 0;
            Store certStore = s.getCertificates();
            SignerInformationStore signers = s.getSignerInfos();
            Collection c = signers.getSigners();
            for (SignerInformation signer : c) {
                Collection certCollection = certStore.getMatches((Selector)signer.getSID());
                Iterator certIt = certCollection.iterator();
                X509CertificateHolder cert = (X509CertificateHolder)certIt.next();
                if (signer.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider("BC").build(cert))) {
                    ++verified;
                }
                cert.getExtension(new ASN1ObjectIdentifier("2.5.29.31")).getExtnValue();
            }
            logger.info(timeStampMessagesBundle.getString("info.signature.verified", new Object[]{verified}));
            byte[] calculatedHash = null;
            if (content != null) {
                Digest digest = DigestFactory.getInstance().factoryDefault();
                digest.setAlgorithm(DigestAlgorithmEnum.SHA_256);
                calculatedHash = digest.digest(content);
            } else {
                calculatedHash = hash;
            }
            if (!Arrays.equals(calculatedHash, timeStampToken.getTimeStampInfo().getMessageImprintDigest())) {
                throw new CertificateCoreException(timeStampMessagesBundle.getString("info.timestamp.hash.nok"));
            }
            logger.info(timeStampMessagesBundle.getString("info.timestamp.hash.ok"));
        }
        catch (IOException | CertificateException | CMSException | OperatorCreationException | TSPException ex) {
            throw new CertificateCoreException(ex.getMessage());
        }
    }

    public void setTimestamp(Timestamp timestamp) {
        this.timestamp = timestamp;
    }

    public Timestamp getTimestamp() {
        return this.timestamp;
    }
}

