/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.timestamp.utils;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.demoiselle.signer.core.util.MessagesBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeStampConfig {
    private static final Logger logger = LoggerFactory.getLogger(TimeStampConfig.class);
    private static TimeStampConfig instance = null;
    private static ResourceBundle bundle = null;
    private static MessagesBundle timeStampMessagesBundle = new MessagesBundle();
    private String tspHostname;
    private int tspPort;
    private String tspOid;

    public static TimeStampConfig getInstance() {
        if (instance == null) {
            instance = new TimeStampConfig();
        }
        return instance;
    }

    public ResourceBundle getBundle(String bundleName) {
        return ResourceBundle.getBundle(bundleName);
    }

    protected TimeStampConfig() {
        if (bundle == null) {
            try {
                bundle = this.getBundle("timestamp-config");
            }
            catch (MissingResourceException mre) {
                try {
                    bundle = this.getBundle("timestamp-config-default");
                }
                catch (MissingResourceException e) {
                    logger.info(e.getMessage());
                }
            }
        }
    }

    public String getTspHostname() {
        try {
            this.tspHostname = bundle.getString("tsp_hostname");
        }
        catch (MissingResourceException e) {
            throw new RuntimeException(timeStampMessagesBundle.getString("error.timestamp.config", new Object[]{"tspHostname"}));
        }
        return this.tspHostname;
    }

    public int getTSPPort() {
        try {
            this.tspPort = Integer.parseInt(bundle.getString("tsp_port"));
        }
        catch (MissingResourceException e) {
            throw new RuntimeException(timeStampMessagesBundle.getString("error.timestamp.config", new Object[]{"tspPort"}));
        }
        return this.tspPort;
    }

    public String getTSPOid() {
        try {
            this.tspOid = bundle.getString("tsp_oid");
        }
        catch (MissingResourceException e) {
            throw new RuntimeException(timeStampMessagesBundle.getString("error.timestamp.config", new Object[]{"tspOid"}));
        }
        return this.tspOid;
    }
}

