/*
 * Decompiled with CFR 0.152.
 */
package org.devocative.demeter.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.poi.util.IOUtils;
import org.devocative.adroit.ConfigUtil;
import org.devocative.adroit.IConfigKey;
import org.devocative.demeter.DSystemException;
import org.devocative.demeter.DemeterConfigKey;
import org.devocative.demeter.entity.EFileStatus;
import org.devocative.demeter.entity.EFileStorage;
import org.devocative.demeter.entity.EMimeType;
import org.devocative.demeter.entity.FileStore;
import org.devocative.demeter.entity.User;
import org.devocative.demeter.iservice.FileStoreHandler;
import org.devocative.demeter.iservice.IFileStoreService;
import org.devocative.demeter.iservice.ISecurityService;
import org.devocative.demeter.iservice.persistor.IPersistorService;
import org.devocative.demeter.vo.UserVO;
import org.devocative.demeter.vo.filter.FileStoreFVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="dmtFileStoreService")
public class FileStoreService
implements IFileStoreService {
    private static final Logger logger = LoggerFactory.getLogger(FileStoreService.class);
    @Autowired
    private IPersistorService persistorService;
    @Autowired
    private ISecurityService securityService;

    public void saveOrUpdate(FileStore entity) {
        this.persistorService.saveOrUpdate((Object)entity);
    }

    public FileStore load(Long id) {
        return (FileStore)this.persistorService.get(FileStore.class, (Serializable)id);
    }

    public FileStore loadByFileId(String fileId) {
        FileStore result = (FileStore)this.persistorService.createQueryBuilder().addFrom(FileStore.class, "ent").addWhere("and ent.fileId = :fileId", "fileId", (Object)fileId).object();
        if (result.getStatus() == EFileStatus.VALID && result.getStorage() == EFileStorage.DISK && !new File(result.getPath()).exists()) {
            result.setStatus(EFileStatus.DELETED);
            this.saveOrUpdate(result);
        }
        return result;
    }

    public List<FileStore> list() {
        return this.persistorService.list(FileStore.class);
    }

    public List<FileStore> search(FileStoreFVO filter, long pageIndex, long pageSize) {
        return this.persistorService.createQueryBuilder().addSelect("select ent").addFrom(FileStore.class, "ent").applyFilter(FileStore.class, "ent", (Serializable)filter, new String[0]).setOrderBy("ent.creationDate desc").list((pageIndex - 1L) * pageSize, pageSize);
    }

    public long count(FileStoreFVO filter) {
        return (Long)this.persistorService.createQueryBuilder().addSelect("select count(1)").addFrom(FileStore.class, "ent").applyFilter(FileStore.class, "ent", (Serializable)filter, new String[0]).object();
    }

    public List<User> getCreatorUserList() {
        return this.persistorService.list(User.class);
    }

    public List<User> getModifierUserList() {
        return this.persistorService.list(User.class);
    }

    public void saveOrUpdate(FileStore entity, byte[] bytes) {
        String oldFileId = entity.getFileId();
        OutputStream outputStream = this.createOutputStream(entity);
        try {
            outputStream.write(bytes);
            outputStream.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.saveOrUpdate(entity);
        if (oldFileId != null) {
            this.moveFileAsExpired(oldFileId, EFileStorage.DISK);
        }
    }

    public FileStoreHandler create(String name, EFileStorage storage, EMimeType mimeType, Date expiration, String ... tags) {
        FileStore fileStore = new FileStore();
        fileStore.setName(name);
        fileStore.setStorage(storage);
        fileStore.setStatus(EFileStatus.VALID);
        fileStore.setMimeType(mimeType);
        fileStore.setExpiration(expiration);
        if (tags != null && tags.length > 0) {
            StringBuilder tag = new StringBuilder(tags[0]);
            for (int i = 1; i < tags.length; ++i) {
                tag.append(",").append(tags[i]);
            }
            fileStore.setTag(tag.toString());
        }
        OutputStream outputStream = this.createOutputStream(fileStore);
        return new FileStoreHandler((IFileStoreService)this, outputStream, fileStore);
    }

    public void writeFile(FileStore fileStore, OutputStream outputStream) {
        block16: {
            if (EFileStorage.DISK.equals((Object)fileStore.getStorage())) {
                String path = fileStore.getPath();
                try (FileInputStream inputStream = new FileInputStream(path);){
                    IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                    break block16;
                }
                catch (IOException e) {
                    throw new DSystemException("Can't open file: " + path, (Throwable)e);
                }
            }
            if (EFileStorage.DATA_BASE.equals((Object)fileStore.getStorage())) {
                throw new RuntimeException("Database as storage is not implemented!");
            }
            throw new RuntimeException("Invalid storage for FileStore: " + fileStore.getStorage());
        }
    }

    public void doExpire() {
        logger.info("Starting FileStoreDTask ...");
        try {
            File expiredDir = this.getExpiredDir();
            logger.info("Deleting Old Expired Files");
            FileUtils.deleteDirectory((File)expiredDir);
            Date now = new Date();
            List<String> fileIds = this.listOfExpiredFiles(now);
            logger.info("Start Expiring Files: no=[{}]", (Object)fileIds.size());
            if (!fileIds.isEmpty()) {
                for (String id : fileIds) {
                    this.moveFileAsExpired(id, EFileStorage.DISK);
                }
                logger.info("Files Moved to Expired Dir");
                int updated = this.updateExpiredFilesStatus(now);
                logger.info("Expired files status are updated: no=[{}]", (Object)updated);
            }
        }
        catch (IOException e) {
            logger.error("FileStoreDTask: ", (Throwable)e);
        }
    }

    public List<FileStore> listByCurrentUserAsCreator() {
        UserVO currentUser = this.securityService.getCurrentUser();
        return this.persistorService.createQueryBuilder().addFrom(FileStore.class, "ent").addWhere("and ent.creatorUserId = :userId").addParam("userId", (Object)currentUser.getUserId()).list();
    }

    private OutputStream createOutputStream(FileStore fileStore) {
        if (EFileStorage.DISK.equals((Object)fileStore.getStorage())) {
            String fileId = UUID.randomUUID().toString().replaceAll("-", "");
            fileStore.setFileId(fileId);
            File baseDir = new File(ConfigUtil.getString((IConfigKey)DemeterConfigKey.FileBaseDir));
            if (!baseDir.exists()) {
                baseDir.mkdirs();
            } else if (!baseDir.isDirectory()) {
                throw new DSystemException("Invalid base directory for file: " + ConfigUtil.getString((IConfigKey)DemeterConfigKey.FileBaseDir));
            }
            String fileFQN = baseDir.getAbsolutePath() + File.separator + fileId;
            try {
                return new FileOutputStream(fileFQN);
            }
            catch (FileNotFoundException e) {
                throw new DSystemException("Can't create file: " + fileFQN, (Throwable)e);
            }
        }
        if (EFileStorage.DATA_BASE.equals((Object)fileStore.getStorage())) {
            throw new RuntimeException("Database as storage is not implemented!");
        }
        throw new RuntimeException("Invalid storage for FileStore: " + fileStore.getStorage());
    }

    private List<String> listOfExpiredFiles(Date dt) {
        return this.persistorService.createQueryBuilder().addSelect("select ent.fileId").addFrom(FileStore.class, "ent").addWhere("and ent.expiration < :dt").addParam("dt", dt).addWhere("and ent.status = :st").addParam("st", (Object)EFileStatus.VALID).list();
    }

    private int updateExpiredFilesStatus(Date dt) {
        return this.persistorService.createQueryBuilder().addSelect("update FileStore ent set ent.status = :new_st").addParam("new_st", (Object)EFileStatus.EXPIRED).addWhere("and ent.expiration < :dt").addParam("dt", dt).addWhere("and ent.status = :old_st").addParam("old_st", (Object)EFileStatus.VALID).update();
    }

    private void moveFileAsExpired(String id, EFileStorage storage) {
        if (EFileStorage.DISK.equals((Object)storage)) {
            File expiredDir = this.getExpiredDir();
            String f = ConfigUtil.getString((IConfigKey)DemeterConfigKey.FileBaseDir) + File.separator + id;
            File file = new File(f);
            if (file.exists()) {
                try {
                    FileUtils.moveFileToDirectory((File)file, (File)expiredDir, (boolean)false);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        } else {
            throw new RuntimeException("File Storage Not Supported: " + storage);
        }
    }

    private File getExpiredDir() {
        String dir = ConfigUtil.getString((IConfigKey)DemeterConfigKey.FileBaseDir) + File.separator + "EXPIRED";
        File expiredDir = new File(dir);
        if (!expiredDir.exists()) {
            expiredDir.mkdirs();
        } else if (!expiredDir.isDirectory()) {
            throw new RuntimeException("Invalid directory for expired dir: " + expiredDir);
        }
        return expiredDir;
    }
}

