/*
 * Decompiled with CFR 0.152.
 */
package org.devocative.demeter.service;

import java.io.Serializable;
import java.util.List;
import org.devocative.demeter.entity.ERowMode;
import org.devocative.demeter.entity.Person;
import org.devocative.demeter.entity.User;
import org.devocative.demeter.iservice.IPersonService;
import org.devocative.demeter.iservice.persistor.IPersistorService;
import org.devocative.demeter.vo.filter.PersonFVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="dmtPersonService")
public class PersonService
implements IPersonService {
    private static final Logger logger = LoggerFactory.getLogger(PersonService.class);
    @Autowired
    private IPersistorService persistorService;

    public void saveOrUpdate(Person entity) {
        if (entity.getRowMode() == null) {
            entity.setRowMode(ERowMode.NORMAL);
        }
        this.persistorService.saveOrUpdate((Object)entity);
    }

    public Person load(Long id) {
        return (Person)this.persistorService.get(Person.class, (Serializable)id);
    }

    public List<Person> list() {
        return this.persistorService.list(Person.class);
    }

    public List<Person> search(PersonFVO filter, long pageIndex, long pageSize) {
        return this.persistorService.createQueryBuilder().addSelect("select ent").addFrom(Person.class, "ent").applyFilter(Person.class, "ent", (Serializable)filter, new String[0]).list((pageIndex - 1L) * pageSize, pageSize);
    }

    public long count(PersonFVO filter) {
        return (Long)this.persistorService.createQueryBuilder().addSelect("select count(1)").addFrom(Person.class, "ent").applyFilter(Person.class, "ent", (Serializable)filter, new String[0]).object();
    }

    public List<User> getCreatorUserList() {
        return this.persistorService.list(User.class);
    }

    public List<User> getModifierUserList() {
        return this.persistorService.list(User.class);
    }
}

