/*
 * Decompiled with CFR 0.152.
 */
package org.devocative.demeter.service;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.devocative.demeter.iservice.IRequestService;
import org.devocative.demeter.vo.RequestVO;
import org.springframework.stereotype.Service;

@Service(value="dmtRequestService")
public class RequestService
implements IRequestService {
    private static final ThreadLocal<RequestVO> CURRENT_REQUEST = new ThreadLocal();

    public RequestVO getCurrentRequest() {
        return CURRENT_REQUEST.get();
    }

    public void set(RequestVO requestVO) {
        CURRENT_REQUEST.set(requestVO);
    }

    public void unset() {
        CURRENT_REQUEST.remove();
    }

    public String toJson(Object obj) {
        return this.toJson(obj, null, null);
    }

    public String toJson(Object obj, Map<JsonParser.Feature, Boolean> features, Map<SerializationFeature, Boolean> serializationFeatures) {
        StringWriter sw = new StringWriter();
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationFeature.WRITE_ENUMS_USING_TO_STRING, true);
        if (features != null) {
            for (Map.Entry<JsonParser.Feature, Boolean> entry : features.entrySet()) {
                mapper.configure(entry.getKey(), entry.getValue().booleanValue());
            }
        }
        if (serializationFeatures != null) {
            for (Map.Entry<JsonParser.Feature, Boolean> entry : features.entrySet()) {
                mapper.configure(entry.getKey(), entry.getValue().booleanValue());
            }
        }
        try {
            mapper.writeValue((Writer)sw, obj);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return sw.toString();
    }

    public <T> T fromJson(String json, Class<T> cls) {
        return this.fromJson(json, cls, null, null);
    }

    public <T> T fromJson(String json, Class<T> cls, Map<JsonParser.Feature, Boolean> features, Map<DeserializationFeature, Boolean> deserializationFeatures) {
        ObjectMapper mapper = this.createMapper(features, deserializationFeatures);
        try {
            return (T)mapper.readValue(json, cls);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T fromJson(String json, TypeReference<T> typeReference) {
        return this.fromJson(json, typeReference, null, null);
    }

    public <T> T fromJson(String json, TypeReference<T> typeReference, Map<JsonParser.Feature, Boolean> features, Map<DeserializationFeature, Boolean> deserializationFeatures) {
        ObjectMapper mapper = this.createMapper(features, deserializationFeatures);
        try {
            return (T)mapper.readValue(json, typeReference);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private ObjectMapper createMapper(Map<JsonParser.Feature, Boolean> features, Map<DeserializationFeature, Boolean> deserializationFeatures) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        if (features != null) {
            for (Map.Entry<JsonParser.Feature, Boolean> entry : features.entrySet()) {
                mapper.configure(entry.getKey(), entry.getValue().booleanValue());
            }
        }
        if (deserializationFeatures != null) {
            for (Map.Entry<JsonParser.Feature, Boolean> entry : deserializationFeatures.entrySet()) {
                mapper.configure((DeserializationFeature)entry.getKey(), entry.getValue().booleanValue());
            }
        }
        return mapper;
    }
}

