/*
 * Decompiled with CFR 0.152.
 */
package org.devocative.demeter.service;

import java.io.Serializable;
import java.util.List;
import org.devocative.demeter.DBConstraintViolationException;
import org.devocative.demeter.DemeterErrorCode;
import org.devocative.demeter.DemeterException;
import org.devocative.demeter.entity.ERoleMode;
import org.devocative.demeter.entity.ERowMode;
import org.devocative.demeter.entity.Privilege;
import org.devocative.demeter.entity.Role;
import org.devocative.demeter.entity.User;
import org.devocative.demeter.iservice.IRoleService;
import org.devocative.demeter.iservice.persistor.IPersistorService;
import org.devocative.demeter.vo.filter.RoleFVO;
import org.devocative.demeter.vo.input.RoleIVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="dmtRoleService")
public class RoleService
implements IRoleService {
    private static final Logger logger = LoggerFactory.getLogger(RoleService.class);
    @Autowired
    private IPersistorService persistorService;

    public void saveOrUpdate(Role entity) {
        block4: {
            if (entity.getRowMode() == null) {
                entity.setRowMode(ERowMode.NORMAL);
            }
            if (entity.getRoleMode() == null) {
                entity.setRoleMode(ERoleMode.NORMAL);
            }
            try {
                this.persistorService.saveOrUpdate((Object)entity);
            }
            catch (DBConstraintViolationException e) {
                if (!e.isConstraint("uk_dmt_role_name")) break block4;
                throw new DemeterException(DemeterErrorCode.DuplicateRoleName);
            }
        }
    }

    public void saveOrUpdate(RoleIVO vo) {
        Role entity = vo.toRole();
        this.saveOrUpdate(entity);
        vo.fromRole(entity);
    }

    public Role load(Long id) {
        return (Role)this.persistorService.get(Role.class, (Serializable)id);
    }

    public Role loadByName(String name) {
        return (Role)this.persistorService.createQueryBuilder().addFrom(Role.class, "ent").addWhere("and ent.name = :name").addParam("name", (Object)name).object();
    }

    public List<Role> list() {
        return this.persistorService.list(Role.class);
    }

    public List<Role> search(RoleFVO filter, long pageIndex, long pageSize) {
        return this.persistorService.createQueryBuilder().addSelect("select ent").addFrom(Role.class, "ent").applyFilter(Role.class, "ent", (Serializable)filter, new String[0]).list((pageIndex - 1L) * pageSize, pageSize);
    }

    public long count(RoleFVO filter) {
        return (Long)this.persistorService.createQueryBuilder().addSelect("select count(1)").addFrom(Role.class, "ent").applyFilter(Role.class, "ent", (Serializable)filter, new String[0]).object();
    }

    public List<Privilege> getPermissionsList() {
        return this.persistorService.list(Privilege.class);
    }

    public List<Privilege> getDenialsList() {
        return this.persistorService.list(Privilege.class);
    }

    public List<User> getCreatorUserList() {
        return this.persistorService.list(User.class);
    }

    public List<User> getModifierUserList() {
        return this.persistorService.list(User.class);
    }

    public Role createOrUpdate(String name, ERowMode rowMode, ERoleMode roleMode) {
        Role role = this.loadByName(name);
        if (role == null) {
            role = new Role();
            role.setName(name);
        }
        role.setRoleMode(roleMode);
        role.setRowMode(rowMode);
        this.saveOrUpdate(role);
        return role;
    }

    public Role createOnly(String name, ERowMode rowMode, ERoleMode roleMode) {
        Role role = this.loadByName(name);
        if (role == null) {
            role = new Role();
            role.setName(name);
            role.setRoleMode(roleMode);
            role.setRowMode(rowMode);
            this.saveOrUpdate(role);
        }
        return role;
    }
}

