/*
 * Decompiled with CFR 0.152.
 */
package org.devocative.demeter.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.AuthenticationException;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.transaction.Transactional;
import org.devocative.adroit.ConfigUtil;
import org.devocative.adroit.IConfigKey;
import org.devocative.adroit.StringEncryptorUtil;
import org.devocative.demeter.DLogCtx;
import org.devocative.demeter.DSystemException;
import org.devocative.demeter.DemeterConfigKey;
import org.devocative.demeter.DemeterErrorCode;
import org.devocative.demeter.DemeterException;
import org.devocative.demeter.entity.EAuthMechanism;
import org.devocative.demeter.entity.ERoleMode;
import org.devocative.demeter.entity.ERowMode;
import org.devocative.demeter.entity.EUserStatus;
import org.devocative.demeter.entity.IPrivilegeKey;
import org.devocative.demeter.entity.Privilege;
import org.devocative.demeter.entity.Role;
import org.devocative.demeter.entity.User;
import org.devocative.demeter.iservice.ApplicationLifecyclePriority;
import org.devocative.demeter.iservice.IApplicationLifecycle;
import org.devocative.demeter.iservice.IDPageInstanceService;
import org.devocative.demeter.iservice.IDemeterCoreService;
import org.devocative.demeter.iservice.IOtherAuthenticationService;
import org.devocative.demeter.iservice.IRequestLifecycle;
import org.devocative.demeter.iservice.IRoleService;
import org.devocative.demeter.iservice.ISecurityService;
import org.devocative.demeter.iservice.IUserService;
import org.devocative.demeter.iservice.persistor.IPersistorService;
import org.devocative.demeter.vo.UserInputVO;
import org.devocative.demeter.vo.UserVO;
import org.devocative.demeter.vo.core.DModuleInfoVO;
import org.devocative.demeter.vo.core.DRoleInfoVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="dmtSecurityService")
public class SecurityService
implements ISecurityService,
IApplicationLifecycle,
IRequestLifecycle {
    private static final Logger logger = LoggerFactory.getLogger(SecurityService.class);
    private static final ThreadLocal<UserVO> CURRENT_USER = new ThreadLocal();
    private UserVO system;
    private UserVO guest;
    @Autowired
    private IUserService userService;
    @Autowired
    private IRoleService roleService;
    @Autowired
    private IDPageInstanceService pageInstanceService;
    @Autowired
    private IPersistorService persistorService;
    @Autowired
    private IDemeterCoreService demeterCoreService;
    @Autowired(required=false)
    private IOtherAuthenticationService otherAuthenticationService;

    @Transactional
    public void init() {
        this.storePrivilegeKeys();
        this.system = this.userService.createOrUpdateUser(new UserInputVO("system", null, null, "system", EAuthMechanism.DATABASE).setStatus(EUserStatus.DISABLED).setRowMode(ERowMode.SYSTEM).setSessionTimeout(Integer.valueOf(0)), null, true);
        this.authenticate(this.system);
        this.userService.createOrUpdateUser(new UserInputVO("root", "root", null, "root", EAuthMechanism.DATABASE).setAdmin(Boolean.valueOf(true)).setRowMode(ERowMode.SYSTEM), null, true);
        this.guest = this.userService.createOrUpdateUser(new UserInputVO("guest", null, null, "guest", EAuthMechanism.DATABASE).setStatus(EUserStatus.DISABLED).setRowMode(ERowMode.SYSTEM).setSessionTimeout(Integer.valueOf(-1)), null, true);
        if (!ConfigUtil.getBoolean((IConfigKey)DemeterConfigKey.EnabledSecurity).booleanValue()) {
            this.guest.setAuthenticated(true);
            this.guest.setPageVO(this.pageInstanceService.getDefaultPages());
        }
        this.roleService.createOrUpdate("User", ERowMode.ROOT, ERoleMode.DYNAMIC);
        this.roleService.createOrUpdate("Admin", ERowMode.ROOT, ERoleMode.DYNAMIC);
        this.roleService.createOrUpdate("Root", ERowMode.SYSTEM, ERoleMode.DYNAMIC);
        this.roleService.createOrUpdate("AuthByDB", ERowMode.ROOT, ERoleMode.DYNAMIC);
        this.roleService.createOrUpdate("AuthByLDAP", ERowMode.ROOT, ERoleMode.DYNAMIC);
        this.roleService.createOrUpdate("AuthByOther", ERowMode.ROOT, ERoleMode.DYNAMIC);
        this.storeAdditionalRoles();
    }

    public void shutdown() {
        CURRENT_USER.remove();
    }

    public ApplicationLifecyclePriority getLifecyclePriority() {
        return ApplicationLifecyclePriority.Second;
    }

    public void beforeRequest() {
    }

    public void afterResponse() {
        CURRENT_USER.remove();
    }

    public UserVO getCurrentUser() {
        return CURRENT_USER.get();
    }

    public void authenticate(UserVO userVO) {
        if (userVO == null) {
            throw new DemeterException(DemeterErrorCode.InvalidUser);
        }
        CURRENT_USER.set(userVO);
        DLogCtx.put((String)"user", (Object)userVO.getUsername());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void authenticate(String username, String password) {
        this.resetToGuest();
        UserVO authenticatedUserVO = null;
        User user = this.userService.loadByUsername(username);
        if (user != null) {
            logger.info("Authenticating: username[{}] in DB, status=[{}], auth=[{}]", new Object[]{username, user.getStatus(), user.getAuthMechanism()});
            this.verifyUser(user);
            if (EAuthMechanism.DATABASE.equals((Object)user.getAuthMechanism())) {
                authenticatedUserVO = this.authenticateByDatabase(user, password);
            } else if (EAuthMechanism.LDAP.equals((Object)user.getAuthMechanism())) {
                authenticatedUserVO = this.authenticateByLDAP(username, password, user);
            } else {
                if (!EAuthMechanism.OTHER.equals((Object)user.getAuthMechanism())) throw new DSystemException(String.format("Invalid authenticate mechanism: username=[%s] authMethod=[%s]", username, user.getAuthMechanism()));
                if (this.otherAuthenticationService == null) throw new DSystemException("No IOtherAuthenticationService bean defined: user = " + username);
                if (!ConfigUtil.getBoolean((IConfigKey)DemeterConfigKey.OtherAuthUserPassEnabled).booleanValue()) throw new DSystemException("OtherAuthenticationService not enabled for user/pass authentication: user = " + username);
                authenticatedUserVO = this.authenticateByOther(username, password, user);
            }
        } else {
            Boolean autoRegister = ConfigUtil.getBoolean((IConfigKey)DemeterConfigKey.UserAutoRegister);
            logger.info("Authenticating: username[{}] not in DB, autoRegister=[{}]", (Object)username, (Object)autoRegister);
            if (!autoRegister.booleanValue()) throw new DemeterException(DemeterErrorCode.InvalidUser);
            if (ConfigUtil.hasKey((IConfigKey)DemeterConfigKey.LdapUrl)) {
                authenticatedUserVO = this.authenticateByLDAP(username, password, null);
            }
            if (authenticatedUserVO == null && this.otherAuthenticationService != null && ConfigUtil.getBoolean((IConfigKey)DemeterConfigKey.OtherAuthUserPassEnabled).booleanValue()) {
                authenticatedUserVO = this.authenticateByOther(username, password, null);
            }
            if (authenticatedUserVO == null) {
                throw new DemeterException(DemeterErrorCode.InvalidUser);
            }
        }
        this.afterAuthentication(authenticatedUserVO);
    }

    public UserVO authenticateByUrlParams(Map<String, List<String>> params) {
        if (this.otherAuthenticationService != null && this.otherAuthenticationService.canProceedAuthentication(params)) {
            this.resetToGuest();
            UserInputVO authUserInputVO = this.otherAuthenticationService.authenticate(params);
            if (authUserInputVO != null) {
                User user = this.userService.loadByUsername(authUserInputVO.getUsername());
                if (user != null) {
                    this.verifyUser(user);
                }
                UserVO authUserVO = this.userService.createOrUpdateUser(authUserInputVO, user, ConfigUtil.getBoolean((IConfigKey)DemeterConfigKey.OtherAuthUpdate).booleanValue());
                logger.info("Authenticate by URL: user=[{}] roles=[{}] permissions={} denials={}", new Object[]{authUserVO.getUsername(), authUserVO.getRoles(), authUserVO.getPermissions(), authUserVO.getDenials()});
                this.afterAuthentication(authUserVO);
                return authUserVO;
            }
        }
        return null;
    }

    public void signOut() {
        CURRENT_USER.set(this.guest);
    }

    public UserVO getSystemUser() {
        if (this.system == null) {
            throw new RuntimeException("Can't find UserVO of 'system' ");
        }
        return this.system;
    }

    public UserVO getGuestUser() {
        if (this.guest == null) {
            throw new RuntimeException("Can't find UserVO of 'guest' ");
        }
        return this.guest;
    }

    private void storePrivilegeKeys() {
        List xModules = this.demeterCoreService.getModules();
        for (DModuleInfoVO xModule : xModules) {
            try {
                String privilegeKeyClass = xModule.getPrivilegeKeyClass();
                if (privilegeKeyClass == null) continue;
                Class<?> enumClass = Class.forName(privilegeKeyClass);
                if (enumClass.isEnum()) {
                    ?[] enumConstants;
                    for (Object enumConstant : enumConstants = enumClass.getEnumConstants()) {
                        IPrivilegeKey key = (IPrivilegeKey)enumConstant;
                        key.setModule(xModule.getShortName().toLowerCase());
                        this.checkAndSavePrivilegeKey(key.getName());
                    }
                    continue;
                }
                throw new DSystemException("IPrivilegeKey class must be enum for module: " + xModule.getShortName());
            }
            catch (Exception e) {
                logger.error(String.format("Loading module [%s] privilege keys", xModule.getShortName()), (Throwable)e);
            }
        }
        if (logger.isDebugEnabled()) {
            List list = this.persistorService.list(Privilege.class);
            for (Privilege privilege : list) {
                logger.debug("PrivilegeKey = {}", (Object)privilege);
            }
        }
    }

    private void checkAndSavePrivilegeKey(String name) {
        long cnt = (Long)this.persistorService.createQueryBuilder().addSelect("select count(1)").addFrom(Privilege.class, "ent").addWhere("and ent.name = :name").addParam("name", (Object)name).object();
        if (cnt == 0L) {
            logger.info("Adding PrivilegeKey = {}", (Object)name);
            Privilege privilege = new Privilege();
            privilege.setName(name);
            this.persistorService.saveOrUpdate((Object)privilege);
        }
    }

    private void storeAdditionalRoles() {
        List dModules = this.demeterCoreService.getModules();
        for (DModuleInfoVO dModule : dModules) {
            for (DRoleInfoVO dRole : dModule.getRoles()) {
                Role role = this.roleService.loadByName(dRole.getName());
                if (role == null) {
                    role = new Role();
                    role.setName(dRole.getName());
                    role.setRowMode(ERowMode.NORMAL);
                    role.setRoleMode(ERoleMode.findByName((String)dRole.getName()));
                }
                if (role.getPermissions() == null) {
                    role.setPermissions(new ArrayList());
                }
                List privileges = role.getPermissions();
                String[] permissions = dRole.getPermissions() != null ? dRole.getPermissions().split("[,]") : new String[]{};
                for (String permission : permissions) {
                    String privilegeName = String.format("%s.%s", dModule.getShortName().toLowerCase(), permission.trim());
                    Privilege privilege = (Privilege)this.persistorService.createQueryBuilder().addFrom(Privilege.class, "ent").addWhere("and ent.name = :name").addParam("name", (Object)privilegeName).object();
                    if (privilege == null) {
                        throw new DSystemException("Can't find Privilege: " + privilegeName);
                    }
                    if (privileges.contains(privilege)) continue;
                    privileges.add(privilege);
                }
                this.roleService.saveOrUpdate(role);
            }
        }
    }

    private UserVO authenticateByDatabase(User user, String password) {
        if (password != null) {
            if ((password = StringEncryptorUtil.hash((String)password)).equals(user.getPassword())) {
                return this.userService.getUserVO(user);
            }
            throw new DemeterException(DemeterErrorCode.InvalidUser);
        }
        throw new DemeterException(DemeterErrorCode.InvalidUser);
    }

    private UserVO authenticateByLDAP(String username, String password, User eqUserInDB) {
        logger.info("Authenticating: by LDAP username = [{}]", (Object)username);
        String dnTemplate = ConfigUtil.getString((IConfigKey)DemeterConfigKey.LdapDnTemplate);
        String dn = String.format(dnTemplate, username);
        logger.debug("User DN: {}", (Object)dn);
        Properties env = new Properties();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", ConfigUtil.getString((IConfigKey)DemeterConfigKey.LdapUrl));
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", dn);
        env.put("java.naming.security.credentials", password);
        try {
            InitialDirContext context = new InitialDirContext(env);
            Attributes attrs = context.getAttributes(dn);
            String firstName = null;
            String lastName = null;
            try {
                firstName = this.getValue(attrs.get(ConfigUtil.getString((IConfigKey)DemeterConfigKey.LdapAttrFirstName)));
                lastName = this.getValue(attrs.get(ConfigUtil.getString((IConfigKey)DemeterConfigKey.LdapAttrLastName)));
            }
            catch (Exception e) {
                logger.error("Getting first name & last name from LDAP attributes", (Throwable)e);
            }
            logger.info("Authenticated by LDAP: username=[{}]", (Object)username);
            boolean forceUpdate = eqUserInDB != null && (firstName != null && !firstName.equals(eqUserInDB.getPerson().getFirstName()) || lastName != null && !lastName.equals(eqUserInDB.getPerson().getLastName()));
            return this.userService.createOrUpdateUser(new UserInputVO(username, firstName, lastName, EAuthMechanism.LDAP), eqUserInDB, forceUpdate);
        }
        catch (AuthenticationException e) {
            logger.warn("Authentication By LDAP failed for user: {}", (Object)username);
            throw new DemeterException(DemeterErrorCode.InvalidUser);
        }
        catch (NamingException e) {
            logger.error("Authentication by LDAP error: ", (Throwable)e);
            throw new DSystemException("LDAP Server Problem: ", (Throwable)e);
        }
    }

    private UserVO authenticateByOther(String username, String password, User eqUserInDB) {
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        params.put(ConfigUtil.getString((IConfigKey)DemeterConfigKey.OtherAuthUsernameParam), Collections.singletonList(username));
        params.put(ConfigUtil.getString((IConfigKey)DemeterConfigKey.OtherAuthPasswordParam), Collections.singletonList(password));
        UserInputVO userInputVO = this.otherAuthenticationService.authenticate(params);
        if (userInputVO == null) {
            throw new DemeterException(DemeterErrorCode.InvalidUser);
        }
        logger.info("Authenticated by Other: username=[{}]", (Object)username);
        return this.userService.createOrUpdateUser(userInputVO, eqUserInDB, ConfigUtil.getBoolean((IConfigKey)DemeterConfigKey.OtherAuthUpdate).booleanValue());
    }

    private void afterAuthentication(UserVO authenticatedUserVO) {
        this.userService.updateLastLoginDate(authenticatedUserVO.getUsername());
        authenticatedUserVO.setAuthenticated(true);
        authenticatedUserVO.addRole(this.roleService.loadByName("User"));
        if (authenticatedUserVO.isAdmin()) {
            authenticatedUserVO.addRole(this.roleService.loadByName("Admin"));
        }
        if (authenticatedUserVO.isRoot()) {
            authenticatedUserVO.addRole(this.roleService.loadByName("Root"));
        }
        if (EAuthMechanism.DATABASE.equals((Object)authenticatedUserVO.getAuthMechanism())) {
            authenticatedUserVO.addRole(this.roleService.loadByName("AuthByDB"));
        } else if (EAuthMechanism.LDAP.equals((Object)authenticatedUserVO.getAuthMechanism())) {
            authenticatedUserVO.addRole(this.roleService.loadByName("AuthByLDAP"));
        } else if (EAuthMechanism.OTHER.equals((Object)authenticatedUserVO.getAuthMechanism())) {
            authenticatedUserVO.addRole(this.roleService.loadByName("AuthByOther"));
        }
        CURRENT_USER.set(authenticatedUserVO);
        logger.info("User Roles: [{}]={}", (Object)authenticatedUserVO, (Object)authenticatedUserVO.getRoles());
    }

    private void verifyUser(User user) {
        if (EUserStatus.DISABLED.equals((Object)user.getStatus())) {
            throw new DemeterException(DemeterErrorCode.UserDisabled);
        }
        if (EUserStatus.LOCKED.equals((Object)user.getStatus())) {
            throw new DemeterException(DemeterErrorCode.UserLocked);
        }
    }

    private String getValue(Attribute attribute) {
        try {
            if (attribute != null && attribute.get() != null) {
                return attribute.get().toString();
            }
        }
        catch (NamingException e) {
            logger.error("LDAP getValue for attr = " + attribute, (Throwable)e);
        }
        return null;
    }

    private void resetToGuest() {
        CURRENT_USER.set(this.guest);
    }
}

