/*
 * Decompiled with CFR 0.152.
 */
package org.devocative.demeter.service;

import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleHash;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import groovy.lang.GroovyShell;
import groovy.text.SimpleTemplateEngine;
import groovy.text.Template;
import groovy.util.DelegatingScript;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.PostConstruct;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.devocative.adroit.ConfigUtil;
import org.devocative.adroit.IConfigKey;
import org.devocative.adroit.cache.ICache;
import org.devocative.demeter.DemeterConfigKey;
import org.devocative.demeter.iservice.ICacheService;
import org.devocative.demeter.iservice.template.IStringTemplate;
import org.devocative.demeter.iservice.template.IStringTemplateService;
import org.devocative.demeter.iservice.template.TemplateEngineType;
import org.devocative.demeter.service.template.FreeMarkerStringTemplate;
import org.devocative.demeter.service.template.GroovyDelegatingScript;
import org.devocative.demeter.service.template.GroovyScript;
import org.devocative.demeter.service.template.GroovyStringTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="dmtStringTemplateService")
public class StringTemplateService
implements IStringTemplateService {
    private static final Logger logger = LoggerFactory.getLogger(StringTemplateService.class);
    private Configuration freeMarkerCfg;
    private ICache<String, IStringTemplate> templateCache;
    private GroovyShell groovyShellForScript;
    private GroovyShell groovyShellForDelegatingScript;
    private SimpleTemplateEngine simpleTemplateEngine;
    @Autowired
    private ICacheService cacheService;

    @PostConstruct
    public void initTemplateService() {
        this.freeMarkerCfg = new Configuration(Configuration.VERSION_2_3_23);
        this.freeMarkerCfg.setObjectWrapper((ObjectWrapper)new CaseInsensitiveVariableWrapper());
        this.groovyShellForScript = new GroovyShell();
        CompilerConfiguration gcc = new CompilerConfiguration();
        gcc.setScriptBaseClass(DelegatingScript.class.getName());
        this.groovyShellForDelegatingScript = new GroovyShell(this.getClass().getClassLoader(), gcc);
        this.simpleTemplateEngine = new SimpleTemplateEngine();
    }

    public IStringTemplate create(String template, TemplateEngineType engineType) {
        String id = UUID.nameUUIDFromBytes(template.getBytes()).toString();
        return this.create(id, template, engineType);
    }

    public IStringTemplate create(String id, String template, TemplateEngineType engineType) {
        IStringTemplate result;
        if (ConfigUtil.getBoolean((IConfigKey)DemeterConfigKey.StringTemplateCacheEnabled).booleanValue() && this.getTemplateCache().containsKey((Object)id)) {
            return (IStringTemplate)this.getTemplateCache().get((Object)id);
        }
        switch (engineType) {
            case FreeMarker: {
                result = this.createFreeMarker(id, template);
                break;
            }
            case GroovyTemplate: {
                result = this.createGroovyTemplate(template);
                break;
            }
            case GroovyScript: {
                result = this.createGroovyScript(template);
                break;
            }
            case GroovyDelegatingScript: {
                result = this.createGroovyDelegatingScript(template);
                break;
            }
            default: {
                throw new RuntimeException("No TemplateEngineType Defined!");
            }
        }
        if (ConfigUtil.getBoolean((IConfigKey)DemeterConfigKey.StringTemplateCacheEnabled).booleanValue()) {
            this.getTemplateCache().put((Object)id, (Object)result);
        }
        return result;
    }

    public void clearCacheFor(String id) {
        if (this.templateCache != null && this.templateCache.containsKey((Object)id)) {
            this.templateCache.remove((Object)id);
        }
    }

    private IStringTemplate createGroovyScript(String template) {
        return new GroovyScript(this.groovyShellForScript.parse(template));
    }

    private IStringTemplate createGroovyDelegatingScript(String template) {
        return new GroovyDelegatingScript((DelegatingScript)this.groovyShellForDelegatingScript.parse(template));
    }

    private IStringTemplate createGroovyTemplate(String template) {
        try {
            Template gTemplate = this.simpleTemplateEngine.createTemplate(template);
            return new GroovyStringTemplate(gTemplate);
        }
        catch (Exception e) {
            logger.error("GroovyStringTemplate.create", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private IStringTemplate createFreeMarker(String id, String template) {
        try {
            freemarker.template.Template fmTemplate = new freemarker.template.Template(id, template, this.freeMarkerCfg);
            return new FreeMarkerStringTemplate(id, fmTemplate);
        }
        catch (IOException e) {
            logger.error("FreeMarkerStringTemplate.create", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private ICache<String, IStringTemplate> getTemplateCache() {
        if (this.templateCache == null) {
            this.templateCache = this.cacheService.create("DMT_STRING_TEMPLATE", 50);
        }
        return this.templateCache;
    }

    private class CaseInsensitiveVariableWrapper
    implements ObjectWrapper {
        private CaseInsensitiveVariableWrapper() {
        }

        public TemplateModel wrap(Object o) throws TemplateModelException {
            if (o != null && o instanceof Map) {
                Map oldMap = (Map)o;
                HashMap newMap = new HashMap();
                for (Map.Entry entry : oldMap.entrySet()) {
                    newMap.put(((String)entry.getKey()).toLowerCase(), entry.getValue());
                }
                return new SimpleHash(newMap, null){
                    private static final long serialVersionUID = 4486615324575062296L;

                    public TemplateModel get(String key) throws TemplateModelException {
                        return super.get(key.toLowerCase());
                    }
                };
            }
            return null;
        }
    }
}

