/*
 * Decompiled with CFR 0.152.
 */
package org.devocative.demeter.service;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import javax.transaction.Transactional;
import org.devocative.adroit.ConfigUtil;
import org.devocative.adroit.IConfigKey;
import org.devocative.adroit.StringEncryptorUtil;
import org.devocative.demeter.DBConstraintViolationException;
import org.devocative.demeter.DemeterConfigKey;
import org.devocative.demeter.DemeterErrorCode;
import org.devocative.demeter.DemeterException;
import org.devocative.demeter.entity.EAuthMechanism;
import org.devocative.demeter.entity.ECalendar;
import org.devocative.demeter.entity.EDatePatternType;
import org.devocative.demeter.entity.EDateTimePatternType;
import org.devocative.demeter.entity.ELocale;
import org.devocative.demeter.entity.ERoleMode;
import org.devocative.demeter.entity.Person;
import org.devocative.demeter.entity.Privilege;
import org.devocative.demeter.entity.Role;
import org.devocative.demeter.entity.User;
import org.devocative.demeter.iservice.IPersonService;
import org.devocative.demeter.iservice.IUserService;
import org.devocative.demeter.iservice.persistor.EJoinMode;
import org.devocative.demeter.iservice.persistor.IPersistorService;
import org.devocative.demeter.vo.UserInputVO;
import org.devocative.demeter.vo.UserVO;
import org.devocative.demeter.vo.filter.UserFVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="dmtUserService")
public class UserService
implements IUserService {
    private static final Logger logger = LoggerFactory.getLogger(UserService.class);
    @Autowired
    private IPersistorService persistorService;
    @Autowired
    private IPersonService personService;

    @Transactional
    public void saveOrUpdate(User entity) {
        block2: {
            this.persistorService.assertActiveTrx();
            this.personService.saveOrUpdate(entity.getPerson());
            entity.setId(entity.getPerson().getId());
            try {
                this.persistorService.saveOrUpdate((Object)entity);
            }
            catch (DBConstraintViolationException e) {
                if (!e.isConstraint("uk_dmt_user_username")) break block2;
                throw new DemeterException(DemeterErrorCode.DuplicateUsername);
            }
        }
    }

    public User load(Long id) {
        return (User)this.persistorService.createQueryBuilder().addFrom(User.class, "ent").addJoin("prs", "ent.person", EJoinMode.LeftFetch).addWhere("and ent.id = :id", "id", (Object)id).object();
    }

    public User loadByUsername(String username) {
        return (User)this.persistorService.createQueryBuilder().addFrom(User.class, "ent").addJoin("prs", "ent.person", EJoinMode.LeftFetch).addWhere("and ent.username = :username", "username", (Object)username).object();
    }

    public List<User> list() {
        return this.persistorService.list(User.class);
    }

    public List<User> search(UserFVO filter, long pageIndex, long pageSize) {
        return this.persistorService.createQueryBuilder().addSelect("select ent").addFrom(User.class, "ent").applyFilter(User.class, "ent", (Serializable)filter, new String[0]).list((pageIndex - 1L) * pageSize, pageSize);
    }

    public long count(UserFVO filter) {
        return (Long)this.persistorService.createQueryBuilder().addSelect("select count(1)").addFrom(User.class, "ent").applyFilter(User.class, "ent", (Serializable)filter, new String[0]).object();
    }

    public List<Role> getRolesList() {
        return this.persistorService.createQueryBuilder().addFrom(Role.class, "ent").addWhere("and ent.roleMode <> :mode").addParam("mode", (Object)ERoleMode.DYNAMIC).setOrderBy("ent.name").list();
    }

    public List<Privilege> getPermissionsList() {
        return this.persistorService.list(Privilege.class);
    }

    public List<Privilege> getDenialsList() {
        return this.persistorService.list(Privilege.class);
    }

    @Transactional
    public void saveOrUpdate(User user, String password) {
        user.getPerson().setHasUser(Boolean.valueOf(true));
        if (password != null) {
            user.setPassword(StringEncryptorUtil.hash((String)password));
        }
        this.saveOrUpdate(user);
    }

    @Transactional
    public void updateUser(User user, String password, String oldPassword) {
        String old = StringEncryptorUtil.hash((String)oldPassword);
        if (!old.equals(user.getPassword())) {
            throw new DemeterException(DemeterErrorCode.InvalidCurrentPassword);
        }
        user.setPassword(StringEncryptorUtil.hash((String)password));
        this.saveOrUpdate(user);
    }

    @Transactional
    public UserVO createOrUpdateUser(UserInputVO userInputVO, User user, boolean forceUpdate) {
        if (user == null) {
            user = this.loadByUsername(userInputVO.getUsername());
        }
        String password = userInputVO.getPassword();
        if (user == null) {
            user = new User();
        } else {
            password = null;
        }
        if (user.getId() == null || forceUpdate) {
            Person person;
            user.setUsername(userInputVO.getUsername());
            if (userInputVO.getStatus() != null) {
                user.setStatus(userInputVO.getStatus());
            }
            if (userInputVO.getAdmin() != null) {
                user.setAdmin(userInputVO.getAdmin());
            }
            user.setAuthMechanism(userInputVO.getAuthMechanism());
            if (userInputVO.getSessionTimeout() != null) {
                user.setSessionTimeout(userInputVO.getSessionTimeout());
            }
            if ((person = user.getPerson()) == null) {
                person = new Person();
                user.setPerson(person);
            }
            person.setFirstName(userInputVO.getFirstName());
            person.setLastName(userInputVO.getLastName());
            if (userInputVO.getRowMode() != null) {
                person.setRowMode(userInputVO.getRowMode());
            }
            this.saveOrUpdate(user, password);
        }
        return this.getUserVO(user).setOtherId(userInputVO.getOtherId()).updateOtherData(userInputVO.getOtherData());
    }

    public UserVO loadVOByUsername(String username) {
        User user = this.loadByUsername(username);
        if (user == null) {
            throw new DemeterException(DemeterErrorCode.InvalidUser, username);
        }
        return this.getUserVO(user);
    }

    public UserVO getUserVO(User user) {
        ELocale defLocale = ELocale.findByCode((String)ConfigUtil.getString((IConfigKey)DemeterConfigKey.UserDefaultLocale));
        ECalendar defCalendar = ECalendar.findByName((String)ConfigUtil.getString((IConfigKey)DemeterConfigKey.UserDefaultCalendar));
        String defTimeZone = ConfigUtil.getString((IConfigKey)DemeterConfigKey.UserDefaultTimeZone);
        Integer sto = user.getSessionTimeout();
        if (sto == null) {
            if (EAuthMechanism.DATABASE.equals((Object)user.getAuthMechanism())) {
                sto = ConfigUtil.getInteger((IConfigKey)DemeterConfigKey.STO_Database);
            } else if (EAuthMechanism.LDAP.equals((Object)user.getAuthMechanism())) {
                sto = ConfigUtil.getInteger((IConfigKey)DemeterConfigKey.STO_LDAP);
            } else if (EAuthMechanism.OTHER.equals((Object)user.getAuthMechanism())) {
                sto = ConfigUtil.getInteger((IConfigKey)DemeterConfigKey.STO_Other);
            }
            if (user.getAdmin().booleanValue()) {
                sto = ConfigUtil.getInteger((IConfigKey)DemeterConfigKey.STO_Admin);
            }
        }
        ELocale userLocale = user.getLocale() != null ? user.getLocale() : defLocale;
        Person person = user.getPersonSafely();
        UserVO userVO = new UserVO(user.getId(), user.getUsername(), person.getFirstName(), person.getLastName()).setAdmin(user.getAdmin().booleanValue()).setAuthMechanism(user.getAuthMechanism()).setLocale(userLocale).setLayoutDirection(userLocale.getLayoutDirection()).setCalendar(user.getCalendarType() != null ? user.getCalendarType() : (defCalendar != null ? defCalendar : userLocale.getDefaultCalendar())).setTimeZone(TimeZone.getTimeZone(user.getTimeZone() != null ? user.getTimeZone() : defTimeZone)).setDatePatternType(user.getDatePatternType() != null ? user.getDatePatternType() : EDatePatternType.P01).setDateTimePatternType(user.getDateTimePatternType() != null ? user.getDateTimePatternType() : EDateTimePatternType.P01).setSessionTimeout(sto);
        if (user.getRoles() != null) {
            user.getRoles().forEach(arg_0 -> ((UserVO)userVO).addRole(arg_0));
        }
        if (user.getPermissions() != null) {
            for (Privilege privilege : user.getPermissions()) {
                userVO.addPermission(privilege.getName());
            }
        }
        if (user.getDenials() != null) {
            for (Privilege privilege : user.getDenials()) {
                userVO.addDenial(privilege.getName());
            }
        }
        logger.info("UserVO: username=[{}] permissions=[{}], denials=[{}]", new Object[]{userVO.getUsername(), userVO.getPermissions(), userVO.getDenials()});
        return userVO;
    }

    @Transactional
    public void updateLastLoginDate(String username) {
        this.persistorService.createQueryBuilder().addSelect("update User ent set ent.lastLoginDate = :lld where ent.username = :username").addParam("lld", new Date()).addParam("username", (Object)username).update();
    }
}

