/*
 * Decompiled with CFR 0.152.
 */
package org.devocative.demeter.service.hibernate;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import org.devocative.demeter.entity.ERoleMode;
import org.devocative.demeter.entity.ERowMode;
import org.devocative.demeter.entity.ICreationDate;
import org.devocative.demeter.entity.ICreatorUser;
import org.devocative.demeter.entity.IModificationDate;
import org.devocative.demeter.entity.IModifierUser;
import org.devocative.demeter.entity.IRoleRowAccess;
import org.devocative.demeter.entity.IRowMode;
import org.devocative.demeter.entity.Person;
import org.devocative.demeter.entity.Role;
import org.devocative.demeter.iservice.ISecurityService;
import org.devocative.demeter.vo.UserVO;
import org.hibernate.EmptyInterceptor;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HibernateInterceptor
extends EmptyInterceptor {
    private static final long serialVersionUID = -820555101887857570L;
    private static Logger logger = LoggerFactory.getLogger(HibernateInterceptor.class);
    private ISecurityService securityService;

    public HibernateInterceptor(ISecurityService securityService) {
        this.securityService = securityService;
    }

    public boolean onSave(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
        boolean result = false;
        if (entity instanceof ICreationDate || entity instanceof ICreatorUser) {
            this.setCreatedValues(entity, id, state, propertyNames);
            result = true;
        }
        return result;
    }

    public boolean onFlushDirty(Object entity, Serializable id, Object[] currentState, Object[] previousState, String[] propertyNames, Type[] types) {
        boolean result = false;
        if (entity instanceof IModificationDate || entity instanceof IModifierUser) {
            this.setModifiedValues(entity, id, currentState, propertyNames);
            result = true;
        }
        return result;
    }

    private void setCreatedValues(Object entity, Serializable id, Object[] state, String[] propertyNames) {
        for (int i = 0; i < propertyNames.length; ++i) {
            if ("creatorUserId".equals(propertyNames[i])) {
                if (this.securityService != null && this.securityService.getCurrentUser() != null) {
                    state[i] = this.securityService.getCurrentUser().getUserId();
                    continue;
                }
                logger.warn("Hibernate.Interceptor for creatorUserId: invalid currentUser, entity=[{}] id=[{}]", (Object)entity.getClass().getName(), (Object)id);
                if (entity instanceof Person) {
                    Person p = (Person)entity;
                    if ("system".equals(p.getLastName())) continue;
                    throw new RuntimeException("Invalid CurrentUser");
                }
                throw new RuntimeException("Invalid CurrentUser");
            }
            if (!"creationDate".equals(propertyNames[i])) continue;
            state[i] = new Date();
        }
    }

    private void setModifiedValues(Object entity, Serializable id, Object[] state, String[] propertyNames) {
        for (int i = 0; i < propertyNames.length; ++i) {
            if ("modifierUserId".equals(propertyNames[i])) {
                if (this.securityService != null && this.securityService.getCurrentUser() != null) {
                    state[i] = this.securityService.getCurrentUser().getUserId();
                    continue;
                }
                logger.error("Hibernate.Interceptor for creatorUserId: invalid currentUser, entity=[{}] id=[{}]", (Object)entity.getClass().getName(), (Object)id);
                if (entity instanceof Person) {
                    Person p = (Person)entity;
                    if ("system".equals(p.getLastName())) continue;
                    throw new RuntimeException("Invalid CurrentUser");
                }
                throw new RuntimeException("Invalid CurrentUser");
            }
            if (!"modificationDate".equals(propertyNames[i])) continue;
            state[i] = new Date();
        }
    }

    private boolean setRowLevelAccess(Object entity, Serializable id, Object[] state, String[] propertyNames) {
        IRowMode rowMode = (IRowMode)entity;
        IRoleRowAccess roleRowAccess = (IRoleRowAccess)entity;
        if (ERowMode.ROLE.equals((Object)rowMode.getRowMode())) {
            for (int i = 0; i < propertyNames.length; ++i) {
                if (!"allowedRoles".equals(propertyNames[i])) continue;
                if (roleRowAccess.getAllowedRoles() != null && !roleRowAccess.getAllowedRoles().isEmpty()) break;
                UserVO currentUser = this.securityService.getCurrentUser();
                if (currentUser != null && currentUser.getRoles() != null && currentUser.getRoles().size() > 0) {
                    ArrayList<Role> roles = new ArrayList<Role>();
                    for (Role role : currentUser.getRoles()) {
                        if (ERoleMode.DYNAMIC.equals((Object)role.getRoleMode())) continue;
                        roles.add(role);
                        break;
                    }
                    state[i] = roles;
                    return true;
                }
                logger.error("Invalid current user & roles: user={}, entity={}, id={}", new Object[]{currentUser, entity.getClass().getName(), id});
                break;
            }
        }
        return false;
    }
}

