/*
 * Decompiled with CFR 0.152.
 */
package org.devocative.demeter.service.hibernate;

import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.PersistenceException;
import javax.transaction.Transactional;
import org.apache.commons.beanutils.PropertyUtils;
import org.devocative.adroit.ConfigUtil;
import org.devocative.adroit.IConfigKey;
import org.devocative.adroit.ObjectUtil;
import org.devocative.adroit.obuilder.MapBuilder;
import org.devocative.demeter.DBConstraintViolationException;
import org.devocative.demeter.DSystemException;
import org.devocative.demeter.DemeterConfigKey;
import org.devocative.demeter.DemeterErrorCode;
import org.devocative.demeter.DemeterException;
import org.devocative.demeter.iservice.ApplicationLifecyclePriority;
import org.devocative.demeter.iservice.ISecurityService;
import org.devocative.demeter.iservice.persistor.ELockMode;
import org.devocative.demeter.iservice.persistor.IPersistorService;
import org.devocative.demeter.iservice.persistor.IQueryBuilder;
import org.devocative.demeter.service.hibernate.HibernateInterceptor;
import org.devocative.demeter.service.hibernate.HibernateQueryBuilder;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.SessionFactoryBuilder;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.proxy.HibernateProxyHelper;
import org.hibernate.query.Query;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.tool.hbm2ddl.SchemaUpdate;
import org.hibernate.tool.schema.TargetType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class HibernatePersistorService
implements IPersistorService {
    private static final Logger logger = LoggerFactory.getLogger(HibernatePersistorService.class);
    private static final ThreadLocal<Session> currentSession = new ThreadLocal();
    private static final ThreadLocal<AtomicInteger> currentTrxLevel = new ThreadLocal();
    private static final Pattern HSQLDB_CONSTRAINT_NAME = Pattern.compile("unique constraint or index violation; (.+?) table:");
    private ThreadPoolExecutor timeOutExecutor;
    private List<Class> entities;
    private String prefix;
    private Metadata metaData;
    private SessionFactory sessionFactory;
    @Autowired
    private ISecurityService securityService;

    public void init() {
        Boolean applyDDL;
        String username = ConfigUtil.getString((boolean)true, (String)this.getConfig("db.username"));
        MapBuilder settingsBuilder = new MapBuilder(new HashMap()).put((Object)"hibernate.dialect", (Object)ConfigUtil.getString((boolean)true, (String)this.getConfig("db.dialect"))).put((Object)"hibernate.connection.driver_class", (Object)ConfigUtil.getString((boolean)true, (String)this.getConfig("db.driver"))).put((Object)"hibernate.connection.url", (Object)ConfigUtil.getString((boolean)true, (String)this.getConfig("db.url"))).put((Object)"hibernate.connection.username", (Object)username).put((Object)"hibernate.connection.password", (Object)ConfigUtil.getString((String)this.getConfig("db.password"), (String)"")).put((Object)"hibernate.show_sql", (Object)ConfigUtil.getString((String)this.getConfig("db.showSQL"), (String)"false"));
        String schema = ConfigUtil.getString((boolean)false, (String)this.getConfig("db.schema"));
        if (schema != null) {
            settingsBuilder.put((Object)"hibernate.default_schema", (Object)schema);
        }
        if ((applyDDL = ConfigUtil.getBoolean((String)this.getConfig("db.update.ddl"), (Boolean)false)).booleanValue()) {
            settingsBuilder.put((Object)"hibernate.hbm2ddl.auto", (Object)"update");
        }
        StandardServiceRegistryBuilder serviceRegistryBuilder = new StandardServiceRegistryBuilder();
        StandardServiceRegistry serviceRegistry = serviceRegistryBuilder.applySettings(settingsBuilder.get()).configure("hibernate.cfg.xml").build();
        MetadataSources metadataSources = new MetadataSources((ServiceRegistry)serviceRegistry);
        this.entities.forEach(arg_0 -> ((MetadataSources)metadataSources).addAnnotatedClass(arg_0));
        this.metaData = metadataSources.buildMetadata();
        SessionFactoryBuilder sessionFactoryBuilder = this.metaData.getSessionFactoryBuilder();
        String interceptor = ConfigUtil.getString((String)this.getConfig("db.interceptor"), (String)"CreateModify");
        if ("CreateModify".equals(interceptor)) {
            sessionFactoryBuilder.applyInterceptor((Interceptor)new HibernateInterceptor(this.securityService));
        } else {
            logger.warn("HibernatePersistorService without CreateModifyInterceptor!");
        }
        this.sessionFactory = sessionFactoryBuilder.build();
        logger.info("HibernatePersistorService init()");
        String scriptFile = ConfigUtil.getString((String)this.getConfig("db.script"), null);
        if (scriptFile != null) {
            logger.info("Executing script file: {}", (Object)scriptFile);
            try {
                File f = new File(scriptFile);
                String sql = new String(Files.readAllBytes(f.toPath()));
                this.executeScript(sql, ";");
            }
            catch (Exception e) {
                logger.error("Executing script file: ", (Throwable)e);
            }
        }
        if (ConfigUtil.getBoolean((IConfigKey)DemeterConfigKey.DatabaseCheckTimeoutEnabled).booleanValue()) {
            this.timeOutExecutor = new ThreadPoolExecutor(ConfigUtil.getInteger((IConfigKey)DemeterConfigKey.DatabaseCheckTimeoutMin), ConfigUtil.getInteger((IConfigKey)DemeterConfigKey.DatabaseCheckTimeoutMax), 1L, TimeUnit.MINUTES, new ArrayBlockingQueue<Runnable>(ConfigUtil.getInteger((IConfigKey)DemeterConfigKey.DatabaseCheckTimeoutList)));
            logger.info("HibernatePersistorService -> TimeOutExecutor Created.");
        }
    }

    public void shutdown() {
        try {
            this.endSession();
        }
        catch (Exception e) {
            logger.error("HibernatePersistorService.shutdown(): endSession", (Throwable)e);
        }
        try {
            this.sessionFactory.close();
        }
        catch (HibernateException e) {
            logger.error("HibernatePersistorService.shutdown(): sessionFactory.close()", (Throwable)e);
        }
        currentSession.remove();
        if (this.timeOutExecutor != null) {
            this.timeOutExecutor.shutdown();
        }
    }

    public ApplicationLifecyclePriority getLifecyclePriority() {
        return ApplicationLifecyclePriority.First;
    }

    public void beforeRequest() {
    }

    public void afterResponse() {
        this.endSession();
    }

    public void setInitData(List<Class> entities, String prefix) {
        this.entities = entities;
        this.prefix = prefix;
    }

    public void startTrx() {
        this.startTrx(false);
    }

    public void startTrx(boolean forceNew) {
        Transaction trx = this.getCurrentTrx();
        int level = currentTrxLevel.get().incrementAndGet();
        if (trx.isActive()) {
            if (level == 0) {
                throw new DemeterException(DemeterErrorCode.TrxInvalidLevel, String.format("level = %s, active = %s", level, trx.isActive()));
            }
            if (forceNew) {
                throw new DemeterException(DemeterErrorCode.TrxAlreadyActiveNoForce);
            }
        } else {
            if (level > 1) {
                throw new DemeterException(DemeterErrorCode.TrxInvalidLevel, String.format("level = %s, active = %s", level, trx.isActive()));
            }
            trx.begin();
        }
    }

    public void assertActiveTrx() {
        int level = currentTrxLevel.get().get();
        Transaction trx = this.getCurrentTrx();
        if (!trx.isActive() || level == 0) {
            throw new DemeterException(DemeterErrorCode.TrxNotActive, String.format("level = %s, active = %s", level, trx.isActive()));
        }
    }

    public void commitOrRollback() {
        this.assertActiveTrx();
        Transaction trx = this.getCurrentTrx();
        AtomicInteger trxLevel = currentTrxLevel.get();
        try {
            if (trxLevel.decrementAndGet() == 0) {
                trx.commit();
            }
        }
        catch (Exception e) {
            logger.error("Hibernate commitOrRollback(): ", (Throwable)e);
            trx.rollback();
            throw e;
        }
    }

    public void rollback() {
        currentTrxLevel.get().set(0);
        Transaction trx = this.getCurrentTrx();
        if (trx.isActive()) {
            trx.rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endSession() {
        Session session = currentSession.get();
        int level = currentTrxLevel.get() != null ? currentTrxLevel.get().get() : 0;
        try {
            if (session != null && session.isOpen()) {
                Transaction trx = session.getTransaction();
                if (trx.isActive()) {
                    trx.rollback();
                    throw new DemeterException(DemeterErrorCode.TrxInvalidActive);
                }
                if (level > 0) {
                    throw new DemeterException(DemeterErrorCode.TrxInvalidLevel, "level = " + level);
                }
            }
        }
        finally {
            currentTrxLevel.remove();
            currentSession.remove();
            if (session != null && session.isOpen()) {
                session.close();
            }
        }
    }

    @Transactional
    public void saveOrUpdate(Object obj) {
        this.assertActiveTrx();
        try {
            Session session = this.getCurrentSession();
            session.saveOrUpdate(obj);
            session.flush();
        }
        catch (PersistenceException e) {
            this.processPersistenceException(e);
        }
    }

    @Transactional
    public Serializable save(Object obj) {
        this.assertActiveTrx();
        try {
            Session session = this.getCurrentSession();
            Serializable result = session.save(obj);
            session.flush();
            return result;
        }
        catch (PersistenceException e) {
            this.processPersistenceException(e);
            return null;
        }
    }

    @Transactional
    public void update(Object obj) {
        this.assertActiveTrx();
        try {
            Session session = this.getCurrentSession();
            session.update(obj);
            session.flush();
        }
        catch (PersistenceException e) {
            this.processPersistenceException(e);
        }
    }

    @Transactional
    public Object updateFields(Object obj, String ... fields) {
        if (fields != null && fields.length > 0) {
            this.assertActiveTrx();
            Class cls = HibernateProxyHelper.getClassWithoutInitializingProxy((Object)obj);
            String idPropName = this.metaData.getIdentifierPropertyName(cls.getName());
            Object idPropValue = ObjectUtil.getPropertyValue((Object)obj, (String)idPropName, (boolean)false);
            StringBuilder builder = new StringBuilder();
            builder.append("update ").append(cls.getName()).append(" ent set ent.").append(fields[0]).append(" = :f0");
            for (int i = 1; i < fields.length; ++i) {
                builder.append(", ent.").append(fields[i]).append(" = :f").append(i);
            }
            builder.append(" where ent.").append(idPropName).append(" = :id");
            logger.debug("HibernatePersistorService.updateFields Query: {}", (Object)builder.toString());
            try {
                Session session = this.getCurrentSession();
                Query query = session.createQuery(builder.toString());
                for (int i = 0; i < fields.length; ++i) {
                    query.setParameter("f" + i, ObjectUtil.getPropertyValue((Object)obj, (String)fields[i], (boolean)false));
                }
                query.setParameter("id", idPropValue);
                query.executeUpdate();
                session.flush();
            }
            catch (PersistenceException e) {
                this.processPersistenceException(e);
            }
            return idPropValue;
        }
        throw new DSystemException("No Field Passed!");
    }

    @Transactional
    public void persist(Object obj) {
        this.assertActiveTrx();
        try {
            Session session = this.getCurrentSession();
            session.persist(obj);
            session.flush();
        }
        catch (PersistenceException e) {
            this.processPersistenceException(e);
        }
    }

    @Transactional
    public <T> T merge(T obj) {
        this.assertActiveTrx();
        try {
            Session session = this.getCurrentSession();
            Object result = session.merge(obj);
            session.flush();
            return (T)result;
        }
        catch (PersistenceException e) {
            this.processPersistenceException(e);
            return null;
        }
    }

    @Transactional
    public void delete(Class entity, Serializable id) {
        this.assertActiveTrx();
        try {
            Session session = this.getCurrentSession();
            String q = String.format("delete from %s ent where ent.id=:entId", entity.getName());
            Query query = session.createQuery(q);
            query.setParameter("entId", (Object)id);
            query.executeUpdate();
            session.flush();
        }
        catch (PersistenceException e) {
            this.processPersistenceException(e);
        }
    }

    @Transactional
    public void delete(Object obj) {
        this.assertActiveTrx();
        try {
            Session session = this.getCurrentSession();
            session.delete(obj);
            session.flush();
        }
        catch (PersistenceException e) {
            this.processPersistenceException(e);
        }
    }

    @Transactional
    public void executeUpdate(String simpleQuery) {
        this.assertActiveTrx();
        try {
            Session session = this.getCurrentSession();
            session.createQuery(simpleQuery).executeUpdate();
            session.flush();
        }
        catch (PersistenceException e) {
            this.processPersistenceException(e);
        }
    }

    public <T> T get(Class<T> entity, Serializable id) {
        return (T)this.getCurrentSession().get(entity, id);
    }

    public <T> T load(Class<T> entity, Serializable id, ELockMode lockMode) {
        LockOptions lockOptions = LockOptions.NONE;
        switch (lockMode) {
            case READ: {
                lockOptions = LockOptions.READ;
                break;
            }
            case UPGRADE: {
                lockOptions = LockOptions.UPGRADE;
            }
        }
        return (T)this.getCurrentSession().load(entity, id, lockOptions);
    }

    public <T> List<T> list(Class<T> entity) {
        return this.list(String.format("from %s ent", entity.getName()));
    }

    public <T> List<T> list(String simpleQuery) {
        Session session = this.getCurrentSession();
        Query query = session.createQuery(simpleQuery);
        return query.list();
    }

    public void refresh(Object entity) {
        try {
            this.getCurrentSession().refresh(entity);
        }
        catch (HibernateException xcp) {
            logger.info(xcp.getMessage());
        }
    }

    public IQueryBuilder createQueryBuilder() {
        return new HibernateQueryBuilder(this);
    }

    public void generateSchemaDiff() {
        new SchemaUpdate().setDelimiter(";").setFormat(true).execute(EnumSet.of(TargetType.STDOUT), this.metaData);
    }

    public void executeScript(String script, String delimiter) {
        Session session = this.getSession();
        session.doWork(connection -> {
            String[] statements;
            for (String statement : statements = script.split(delimiter)) {
                if ((statement = statement.trim()).isEmpty()) continue;
                logger.info("Execute: {}", (Object)statement);
                Statement st = connection.createStatement();
                st.execute(statement);
                st.close();
            }
        });
        session.close();
    }

    public Connection createSqlConnection() throws SQLException {
        try {
            Class.forName(ConfigUtil.getString((boolean)true, (String)this.getConfig("db.driver")));
        }
        catch (ClassNotFoundException e) {
            throw new SQLException(e);
        }
        return DriverManager.getConnection(ConfigUtil.getString((boolean)true, (String)this.getConfig("db.url")), ConfigUtil.getString((boolean)true, (String)this.getConfig("db.username")), ConfigUtil.getString((String)this.getConfig("db.password"), (String)""));
    }

    Session getCurrentSession() {
        Session session = currentSession.get();
        if (session == null || !session.isOpen()) {
            session = this.getSession();
            currentSession.set(session);
            currentTrxLevel.set(new AtomicInteger(0));
        } else {
            try {
                session.createNativeQuery(ConfigUtil.getString((boolean)true, (String)this.getConfig("db.connection.check.query"))).uniqueResult();
            }
            catch (HibernateException e) {
                logger.warn("Check current session error", (Throwable)e);
                currentSession.remove();
                session = this.getCurrentSession();
            }
        }
        return session;
    }

    void processPersistenceException(PersistenceException e) throws PersistenceException {
        if (e.getCause() instanceof ConstraintViolationException) {
            ConstraintViolationException cve = (ConstraintViolationException)e.getCause();
            String constraintName = this.getConstraintName(cve);
            if (constraintName != null) {
                throw new DBConstraintViolationException(constraintName);
            }
            throw e;
        }
        throw e;
    }

    private Session getSession() {
        int noOfRetry = 0;
        while (true) {
            try {
                Session session = this.sessionFactory.openSession();
                if (ConfigUtil.getBoolean((IConfigKey)DemeterConfigKey.DatabaseCheckTimeoutEnabled).booleanValue()) {
                    Future<Boolean> submit = this.timeOutExecutor.submit(new TimeOut(session));
                    Boolean result = submit.get(ConfigUtil.getInteger((IConfigKey)DemeterConfigKey.DatabaseCheckTimeoutDur).intValue(), TimeUnit.SECONDS);
                    if (!result.booleanValue()) {
                        throw new RuntimeException("Checking-Query Timeout!");
                    }
                } else {
                    session.createNativeQuery(ConfigUtil.getString((boolean)true, (String)this.getConfig("db.connection.check.query"))).uniqueResult();
                }
                return session;
            }
            catch (Exception e) {
                logger.error("Problem getting new session", (Throwable)e);
                try {
                    this.sessionFactory.close();
                }
                catch (HibernateException e1) {
                    logger.warn("Problem closing SessionFactory", (Throwable)e);
                }
                if (++noOfRetry > 3) {
                    throw new DemeterException(DemeterErrorCode.DBGetConnectionFailure, "Hint: " + e.getMessage());
                }
                this.init();
                continue;
            }
            break;
        }
    }

    private Transaction getCurrentTrx() {
        Session session = this.getCurrentSession();
        Transaction trx = session.getTransaction();
        if (trx == null) {
            throw new DemeterException(DemeterErrorCode.TrxNoObject);
        }
        return trx;
    }

    private String getConfig(String key) {
        return String.format("%s.%s", this.prefix, key);
    }

    private Map<String, PropertyDescriptor> getPropertyDescriptorsAsMap(Class cls) {
        PropertyDescriptor[] propertyDescriptors;
        LinkedHashMap<String, PropertyDescriptor> result = new LinkedHashMap<String, PropertyDescriptor>();
        for (PropertyDescriptor p : propertyDescriptors = PropertyUtils.getPropertyDescriptors((Class)cls)) {
            result.put(p.getName(), p);
        }
        return result;
    }

    private String getConstraintName(ConstraintViolationException e) {
        if (e.getConstraintName() != null) {
            return e.getConstraintName();
        }
        Matcher matcher = HSQLDB_CONSTRAINT_NAME.matcher(e.getSQLException().getMessage());
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    private class TimeOut
    implements Callable<Boolean> {
        private Session session;

        private TimeOut(Session session) {
            this.session = session;
        }

        @Override
        public Boolean call() {
            try {
                this.session.createNativeQuery(ConfigUtil.getString((boolean)true, (String)HibernatePersistorService.this.getConfig("db.connection.check.query"))).uniqueResult();
                return true;
            }
            catch (Exception e) {
                logger.error("Check-Query Timeout Thread Exception: {}", (Object)e.getMessage());
                return false;
            }
        }
    }
}

