/*
 * Decompiled with CFR 0.152.
 */
package org.devocative.demeter.service.hibernate;

import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.sql.Date;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.PersistenceException;
import org.devocative.adroit.ObjectUtil;
import org.devocative.adroit.vo.RangeVO;
import org.devocative.demeter.DSystemException;
import org.devocative.demeter.filter.CollectionUtil;
import org.devocative.demeter.filter.IFilterEvent;
import org.devocative.demeter.iservice.persistor.EJoinMode;
import org.devocative.demeter.iservice.persistor.IQueryBuilder;
import org.devocative.demeter.service.hibernate.HibernatePersistorService;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HibernateQueryBuilder
implements IQueryBuilder {
    private static final Logger logger = LoggerFactory.getLogger(HibernateQueryBuilder.class);
    private final StringBuilder selectBuilder = new StringBuilder();
    private final StringBuilder whereClauseBuilder = new StringBuilder();
    private final Map<String, Object> params = new HashMap<String, Object>();
    private final Map<String, IQueryBuilder> subQueries = new HashMap<String, IQueryBuilder>();
    private final Map<String, Integer> subQueriesParamIndex = new HashMap<String, Integer>();
    private final Map<String, String> join = new LinkedHashMap<String, String>();
    private final Map<String, String> from = new HashMap<String, String>();
    private int subQueriesIndex = 1;
    private String orderBy;
    private String groupBy;
    private String having;
    private boolean sqlMode = false;
    private Query query;
    private LockOptions lockOptions;
    private final HibernatePersistorService persistorService;

    HibernateQueryBuilder(HibernatePersistorService persistorService) {
        this.persistorService = persistorService;
    }

    public IQueryBuilder setSqlMode(boolean sqlMode) {
        this.sqlMode = sqlMode;
        return this;
    }

    public IQueryBuilder addFrom(String entity, String alias) {
        if (!this.from.containsKey(alias)) {
            this.from.put(alias, entity);
        }
        return this;
    }

    public IQueryBuilder addFrom(Class entity, String alias) {
        this.addFrom(entity.getName(), alias);
        return this;
    }

    public IQueryBuilder addParam(String name, Object value) {
        this.params.put(name, value);
        return this;
    }

    public IQueryBuilder addParam(String name, Calendar value) {
        Date sqlDate = new Date(value.getTimeInMillis());
        this.params.put(name, sqlDate);
        return this;
    }

    public IQueryBuilder addParam(String name, java.util.Date value) {
        Date sqlDate = new Date(value.getTime());
        this.params.put(name, sqlDate);
        return this;
    }

    public IQueryBuilder addParams(Map<String, Object> params) {
        this.params.putAll(params);
        return this;
    }

    public IQueryBuilder addSelect(String selectClause) {
        this.selectBuilder.append(" ").append(selectClause);
        return this;
    }

    public IQueryBuilder addWhere(String whereClause) {
        this.whereClauseBuilder.append(" ").append(whereClause);
        return this;
    }

    public IQueryBuilder addWhere(String whereClause, String paramName, Object paramValue) {
        return this.addWhere(whereClause).addParam(paramName, paramValue);
    }

    public IQueryBuilder addJoin(String alias, String joinExpr) {
        return this.addJoin(alias, joinExpr, EJoinMode.Inner);
    }

    public IQueryBuilder addJoin(String alias, String joinExpr, EJoinMode joinMode) {
        if (!this.join.containsKey(alias)) {
            if (joinExpr.toLowerCase().contains("join")) {
                this.join.put(alias, joinExpr);
            } else {
                this.join.put(alias, String.format("%s %s", joinMode.getExpr(), joinExpr));
            }
        } else {
            throw new DSystemException("Duplicate join alias: " + alias);
        }
        return this;
    }

    public IQueryBuilder addSubQueries(String name, IQueryBuilder builder) {
        this.subQueries.put(name, builder);
        this.subQueriesParamIndex.put(name, this.subQueriesIndex++);
        return this;
    }

    public IQueryBuilder setOrderBy(String order) {
        this.orderBy = order;
        return this;
    }

    public IQueryBuilder setGroupBy(String groupBy) {
        this.groupBy = groupBy;
        return this;
    }

    public IQueryBuilder setHaving(String having) {
        this.having = having;
        return this;
    }

    public IQueryBuilder setLockOptions(LockOptions lockOptions) {
        this.lockOptions = lockOptions;
        return this;
    }

    public <T> List<T> list() {
        this.buildQuery();
        this.applyParams();
        if (this.lockOptions != null) {
            this.query.setLockOptions(this.lockOptions);
        }
        return this.query.list();
    }

    public <T> List<T> list(long firstResult, long maxResults) {
        this.buildQuery();
        this.applyParams();
        if (this.lockOptions != null) {
            this.query.setLockOptions(this.lockOptions);
        }
        List list = this.query.setFirstResult((int)firstResult).setMaxResults((int)maxResults).list();
        return list;
    }

    public <T> T object() {
        this.buildQuery();
        this.applyParams();
        if (this.lockOptions != null) {
            this.query.setLockOptions(this.lockOptions);
        }
        return (T)this.query.uniqueResult();
    }

    public int update() {
        int result = -1;
        this.persistorService.startTrx();
        try {
            Session session = this.persistorService.getCurrentSession();
            this.buildQuery();
            this.applyParams();
            if (this.lockOptions != null) {
                this.query.setLockOptions(this.lockOptions);
            }
            result = this.query.executeUpdate();
            session.flush();
            this.persistorService.commitOrRollback();
        }
        catch (PersistenceException e) {
            this.persistorService.rollback();
            this.persistorService.processPersistenceException(e);
        }
        catch (Exception e) {
            this.persistorService.rollback();
        }
        return result;
    }

    public IQueryBuilder applyFilter(final Class entity, final String alias, Serializable filter, String ... ignoreProperties) {
        CollectionUtil.filter((IFilterEvent)new IFilterEvent(){

            public void ifString(String propName, String value, boolean useLike, boolean caseInsensitive) {
                if (useLike && caseInsensitive) {
                    HibernateQueryBuilder.this.addWhere(String.format("and lower(%1$s.%2$s) like lower(:%2$s_)", alias, propName));
                    HibernateQueryBuilder.this.addParam(propName + "_", "%" + value + "%");
                } else if (useLike) {
                    HibernateQueryBuilder.this.addWhere(String.format("and %1$s.%2$s like :%2$s_", alias, propName));
                    HibernateQueryBuilder.this.addParam(propName + "_", "%" + value + "%");
                } else if (caseInsensitive) {
                    HibernateQueryBuilder.this.addWhere(String.format("and %1$s.%2$s like :%2$s_", alias, propName));
                    HibernateQueryBuilder.this.addParam(propName + "_", value);
                } else {
                    HibernateQueryBuilder.this.addWhere(String.format("and %1$s.%2$s = :%2$s_", alias, propName));
                    HibernateQueryBuilder.this.addParam(propName + "_", value);
                }
            }

            public void ifRange(String propName, RangeVO rangeVO) {
                if (rangeVO.getLower() != null) {
                    HibernateQueryBuilder.this.addWhere(String.format("and %1$s.%2$s >= :%2$s_from", alias, propName));
                    HibernateQueryBuilder.this.addParam(propName + "_from", rangeVO.getLower());
                }
                if (rangeVO.getUpper() != null) {
                    HibernateQueryBuilder.this.addWhere(String.format("and %1$s.%2$s < :%2$s_to", alias, propName));
                    HibernateQueryBuilder.this.addParam(propName + "_to", rangeVO.getUpper());
                }
            }

            public void ifFilterer(String propName, Object value) {
                String newAlias = alias + "_" + propName;
                HibernateQueryBuilder.this.addJoin(newAlias, String.format("%s.%s", alias, propName));
                PropertyDescriptor propertyDescriptor = ObjectUtil.getPropertyDescriptor((Class)entity, (String)propName, (boolean)false);
                if (propertyDescriptor == null) {
                    throw new RuntimeException(String.format("Invalid property [%s] in entity [%s]! The filter and entity should have same property name!", propName, entity.getName()));
                }
                Class entityPropertyType = Collection.class.isAssignableFrom(propertyDescriptor.getPropertyType()) ? (Class)propertyDescriptor.getReadMethod().getGenericParameterTypes()[0] : propertyDescriptor.getPropertyType();
                HibernateQueryBuilder.this.applyFilter(entityPropertyType, newAlias, (Serializable)value, new String[0]);
            }

            public void ifCollection(String propName, Collection col) {
                if (col.size() > 0) {
                    PropertyDescriptor propertyDescriptor = ObjectUtil.getPropertyDescriptor((Class)entity, (String)propName, (boolean)false);
                    if (propertyDescriptor == null) {
                        throw new RuntimeException(String.format("Invalid property [%s] in entity [%s]! The filter and entity should have same property name!", propName, entity.getName()));
                    }
                    if (Collection.class.isAssignableFrom(propertyDescriptor.getPropertyType())) {
                        String newAlias = alias + "_" + propName;
                        HibernateQueryBuilder.this.addJoin(newAlias, String.format("%s.%s", alias, propName));
                        HibernateQueryBuilder.this.addWhere(String.format("and %1$s in :p_%1$s", newAlias));
                        HibernateQueryBuilder.this.addParam("p_" + newAlias, col);
                    } else {
                        HibernateQueryBuilder.this.addWhere(String.format("and %1$s.%2$s in :%2$s_", alias, propName));
                        HibernateQueryBuilder.this.addParam(propName + "_", col);
                    }
                }
            }

            public void ifOther(String propName, Object value) {
                HibernateQueryBuilder.this.addWhere(String.format("and %1$s.%2$s = :%2$s_", alias, propName));
                HibernateQueryBuilder.this.addParam(propName + "_", value);
            }
        }, (Object)filter, (String[])ignoreProperties);
        return this;
    }

    private void buildQuery() {
        if (this.query == null) {
            Session session = this.persistorService.getCurrentSession();
            this.query = this.sqlMode ? session.createNativeQuery(this.buildQueryString(true)) : session.createQuery(this.buildQueryString(true));
        }
    }

    private String buildQueryString(boolean applyOrder) {
        StringBuilder concatAllBuilder = new StringBuilder();
        concatAllBuilder.append(this.selectBuilder.toString());
        if (this.from.size() > 0) {
            concatAllBuilder.append(" from ");
            int noOfFromPart = 1;
            for (Map.Entry<String, String> entry : this.from.entrySet()) {
                concatAllBuilder.append(entry.getValue()).append(" ").append(entry.getKey());
                if (noOfFromPart < this.from.size()) {
                    concatAllBuilder.append(",");
                }
                ++noOfFromPart;
            }
        }
        if (this.join.size() > 0) {
            for (Map.Entry<String, String> entry : this.join.entrySet()) {
                concatAllBuilder.append(" ").append(entry.getValue()).append(" ").append(entry.getKey()).append(" ");
            }
        }
        if (this.whereClauseBuilder.length() > 0) {
            concatAllBuilder.append(" where 1=1 ").append(this.whereClauseBuilder.toString());
        }
        if (this.groupBy != null) {
            concatAllBuilder.append(" group by ").append(this.groupBy);
        }
        if (this.having != null) {
            concatAllBuilder.append(" having ").append(this.having);
        }
        if (applyOrder && this.orderBy != null) {
            concatAllBuilder.append(" order by ").append(this.orderBy);
        }
        String finalQuery = concatAllBuilder.toString();
        if (this.subQueries.size() > 0) {
            for (Map.Entry<String, String> entry : this.subQueries.entrySet()) {
                HibernateQueryBuilder builder = (HibernateQueryBuilder)((Object)entry.getValue());
                String query = builder.buildQueryString(false);
                Integer subQueryIndex = this.subQueriesParamIndex.get(entry.getKey());
                for (Map.Entry<String, Object> paramEntry : builder.params.entrySet()) {
                    query = query.replace(":" + paramEntry.getKey(), ":" + paramEntry.getKey() + subQueryIndex);
                }
                finalQuery = finalQuery.replace("#" + entry.getKey(), "(" + query + ")");
            }
        }
        logger.debug("HibernateQueryBuilder, final: {}", (Object)finalQuery);
        return finalQuery;
    }

    private void applyParams() {
        for (Map.Entry<String, Object> entry : this.params.entrySet()) {
            if (entry.getValue() instanceof Collection) {
                this.query.setParameterList(entry.getKey(), (Collection)entry.getValue());
                continue;
            }
            this.query.setParameter(entry.getKey(), entry.getValue());
        }
        if (this.subQueries.size() > 0) {
            for (Map.Entry<String, Object> entry : this.subQueries.entrySet()) {
                Integer subQueryIndex = this.subQueriesParamIndex.get(entry.getKey());
                HibernateQueryBuilder builder = (HibernateQueryBuilder)entry.getValue();
                Map<String, Object> params = builder.params;
                for (Map.Entry<String, Object> param : params.entrySet()) {
                    if (param.getValue() instanceof Collection) {
                        this.query.setParameterList(param.getKey() + subQueryIndex, (Collection)param.getValue());
                        continue;
                    }
                    this.query.setParameter(param.getKey() + subQueryIndex, param.getValue());
                }
            }
        }
    }
}

