/*
 * Decompiled with CFR 0.152.
 */
package org.devocative.demeter.service.hibernate;

import org.devocative.demeter.DemeterErrorCode;
import org.devocative.demeter.DemeterException;
import org.devocative.demeter.iservice.persistor.IPersistorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionStatus;

public class HibernateTrxManager
extends AbstractPlatformTransactionManager {
    private static final Logger logger = LoggerFactory.getLogger(HibernateTrxManager.class);
    @Autowired
    private IPersistorService persistorService;

    public HibernateTrxManager() {
        logger.info("HibernateTrxManager Instantiated");
    }

    protected Object doGetTransaction() throws TransactionException {
        logger.debug("HibernateTrxManager.doGetTransaction");
        return "TRX";
    }

    protected void doBegin(Object transaction, TransactionDefinition definition) throws TransactionException {
        logger.debug("HibernateTrxManager.doBegin: {}", transaction);
        if (this.validPropagation(definition.getPropagationBehavior())) {
            this.persistorService.startTrx();
        }
        this.assertUnsupportedPropagation(definition.getPropagationBehavior());
    }

    protected void doCommit(DefaultTransactionStatus status) throws TransactionException {
        logger.debug("HibernateTrxManager.doCommit");
        this.persistorService.commitOrRollback();
    }

    protected void doRollback(DefaultTransactionStatus status) throws TransactionException {
        logger.debug("HibernateTrxManager.doRollback");
        this.persistorService.rollback();
    }

    private boolean validPropagation(int propagation) {
        switch (propagation) {
            case 0: 
            case 1: 
            case 2: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    private void assertUnsupportedPropagation(int propagation) {
        switch (propagation) {
            case 3: 
            case 4: 
            case 5: {
                throw new DemeterException(DemeterErrorCode.TrxPropagationNotSupported);
            }
        }
    }
}

