/*
 * Decompiled with CFR 0.152.
 */
package org.devocative.demeter.service.task;

import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import org.devocative.demeter.iservice.ISecurityService;
import org.devocative.demeter.iservice.task.DTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Scope(value="prototype")
@Component(value="dmtSimpleDTask")
public class SimpleDTask
extends DTask<String> {
    private static final Logger logger = LoggerFactory.getLogger(SimpleDTask.class);
    private AtomicBoolean cont = new AtomicBoolean(true);
    private int MAX;
    @Autowired
    private ISecurityService securityService;

    public void init() {
        logger.info("SimpleDTask.init");
        this.MAX = new Random().nextInt(100) + 1;
        this.setDetail(String.valueOf(this.MAX));
    }

    public boolean canStart() {
        return true;
    }

    public void execute() throws Exception {
        logger.info("SimpleDTask.execute: user={}", (Object)this.getCurrentUser());
        Thread th = new Thread(() -> {
            try {
                for (int i = 1; i <= this.MAX && this.cont.get(); ++i) {
                    logger.debug("SimpleDTask: i = {}", (Object)i);
                    Thread.sleep(1000L);
                    this.sendResult(String.format("counter = %02d | user=%s", i, this.securityService.getCurrentUser()));
                }
                logger.info("SimpleDTask.executed: {}", (Object)this.getCurrentUser());
                this.sendResult("SimpleDTask.executed: " + this.getCurrentUser());
            }
            catch (InterruptedException e) {
                logger.warn("SimpleDTask Sleep Interrupted");
            }
        });
        th.start();
        th.join();
    }

    public void cancel() {
        logger.info("SimpleDTask.cancel: {}", (Object)this.getCurrentUser());
        this.cont.set(false);
    }
}

