/*
 * Decompiled with CFR 0.152.
 */
package org.devzendo.commondb.beanminder.persistence.dao.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.devzendo.commondb.beanminder.persistence.dao.AccountsDao;
import org.devzendo.commondb.beanminder.persistence.domain.Account;
import org.devzendo.commondb.beanminder.persistence.domain.AccountCode;
import org.devzendo.commondb.beanminder.persistence.domain.AccountName;
import org.devzendo.commondb.beanminder.persistence.domain.BankName;
import org.devzendo.commondb.beanminder.persistence.domain.CurrentBalance;
import org.devzendo.commondb.beanminder.persistence.domain.InitialBalance;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import scala.Array$;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001I4A!\u0001\u0002\u0001#\t9\"\n\u001a2d)\u0016l\u0007\u000f\\1uK\u0006\u001b7m\\;oiN$\u0015m\u001c\u0006\u0003\u0007\u0011\tA![7qY*\u0011QAB\u0001\u0004I\u0006|'BA\u0004\t\u0003-\u0001XM]:jgR,gnY3\u000b\u0005%Q\u0011A\u00032fC:l\u0017N\u001c3fe*\u00111\u0002D\u0001\tG>lWn\u001c8eE*\u0011QBD\u0001\tI\u00164(0\u001a8e_*\tq\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001%a\u0001\"a\u0005\f\u000e\u0003QQ\u0011!F\u0001\u0006g\u000e\fG.Y\u0005\u0003/Q\u0011a!\u00118z%\u00164\u0007CA\r\u001b\u001b\u0005!\u0011BA\u000e\u0005\u0005-\t5mY8v]R\u001cH)Y8\t\u0011u\u0001!\u0011!Q\u0001\ny\tAB\u001b3cGR+W\u000e\u001d7bi\u0016\u0004\"a\b\u0015\u000e\u0003\u0001R!!\t\u0012\u0002\rMLW\u000e\u001d7f\u0015\t\u0019C%\u0001\u0003d_J,'BA\u0013'\u0003\u0011QGMY2\u000b\u0005\u001dr\u0011aD:qe&twM\u001a:b[\u0016<xN]6\n\u0005%\u0002#AE*j[BdWM\u00133cGR+W\u000e\u001d7bi\u0016DQa\u000b\u0001\u0005\u00021\na\u0001P5oSRtDCA\u00170!\tq\u0003!D\u0001\u0003\u0011\u0015i\"\u00061\u0001\u001f\u0011\u0015\t\u0004\u0001\"\u00013\u0003=1\u0017N\u001c3BY2\f5mY8v]R\u001cH#A\u001a\u0011\u0007QbtH\u0004\u00026u9\u0011a'O\u0007\u0002o)\u0011\u0001\bE\u0001\u0007yI|w\u000e\u001e \n\u0003UI!a\u000f\u000b\u0002\u000fA\f7m[1hK&\u0011QH\u0010\u0002\u0005\u0019&\u001cHO\u0003\u0002<)A\u0011\u0001iQ\u0007\u0002\u0003*\u0011!IB\u0001\u0007I>l\u0017-\u001b8\n\u0005\u0011\u000b%aB!dG>,h\u000e\u001e\u0005\u0006\r\u0002!\taR\u0001\fg\u00064X-Q2d_VtG\u000f\u0006\u0002@\u0011\")\u0011*\u0012a\u0001\u007f\u00059\u0011mY2pk:$\b\"B&\u0001\t\u0003a\u0015!\u00043fY\u0016$X-Q2d_VtG\u000f\u0006\u0002N!B\u00111CT\u0005\u0003\u001fR\u0011A!\u00168ji\")\u0011J\u0013a\u0001\u007f!1!\u000b\u0001C\u0001\u0005M\u000b!#\u001a8tkJ,\u0017iY2pk:$8+\u0019<fIR\u0011Q\n\u0016\u0005\u0006\u0013F\u0003\ra\u0010\u0005\u0007-\u0002!\tAA,\u0002\u00171|\u0017\rZ!dG>,h\u000e\u001e\u000b\u0003\u007faCQ!S+A\u0002}BaA\u0017\u0001\u0005\u0002\tY\u0016!D;qI\u0006$X-Q2d_VtG\u000f\u0006\u0002@9\")\u0011*\u0017a\u0001\u007f!)a\f\u0001C\u0005?\u0006i\u0011N\\:feR\f5mY8v]R$\"a\u00101\t\u000b%k\u0006\u0019A \t\u000b\t\u0004A\u0011B2\u0002'\r\u0014X-\u0019;f\u0003\u000e\u001cw.\u001e8u\u001b\u0006\u0004\b/\u001a:\u0015\u0003\u0011\u00142!Z4p\r\u00111\u0017\r\u00013\u0003\u0019q\u0012XMZ5oK6,g\u000e\u001e \u0011\u0005!lW\"A5\u000b\u0005)\\\u0017\u0001\u00027b]\u001eT\u0011\u0001\\\u0001\u0005U\u00064\u0018-\u0003\u0002oS\n1qJ\u00196fGR\u00042a\b9@\u0013\t\t\bE\u0001\fQCJ\fW.\u001a;fe&TX\r\u001a*po6\u000b\u0007\u000f]3s\u0001")
public class JdbcTemplateAccountsDao
implements AccountsDao {
    private final SimpleJdbcTemplate jdbcTemplate;

    @Override
    public List<Account> findAllAccounts() {
        String sql = "SELECT id, name, with, accountCode, initialBalance, currentBalance FROM Accounts ORDER BY name";
        return ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.jdbcTemplate.query(sql, this.createAccountMapper(), new Object[0])).asScala()).toList();
    }

    @Override
    public Account saveAccount(Account account) {
        return account.id() != -1 ? this.updateAccount(account) : this.insertAccount(account);
    }

    @Override
    public void deleteAccount(Account account) {
        this.ensureAccountSaved(account);
        String sql = "DELETE FROM Accounts WHERE id = ?";
        this.jdbcTemplate.update(sql, new Object[]{Predef$.MODULE$.int2Integer(account.id())});
    }

    public void ensureAccountSaved(Account account) {
        if (account.id() == -1) {
            throw new DataIntegrityViolationException("Cannot store a transaction against an unsaved account");
        }
    }

    public Account loadAccount(Account account) {
        String sql = "SELECT id, name, with, accountCode, initialBalance, currentBalance FROM Accounts WHERE id = ?";
        return (Account)this.jdbcTemplate.queryForObject(sql, this.createAccountMapper(), new Object[]{Predef$.MODULE$.int2Integer(account.id())});
    }

    public Account updateAccount(Account account) {
        this.jdbcTemplate.update("UPDATE Accounts SET name = ?, with = ?, accountCode = ?, currentBalance = ? WHERE id = ?", new Object[]{Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{account.name().toRepresentation(), account.withBank().toRepresentation(), account.accountCode().toRepresentation(), account.currentBalance().toRepresentation(), BoxesRunTime.boxToInteger((int)account.id())}), ClassTag$.MODULE$.Any())});
        return account;
    }

    private Account insertAccount(Account account) {
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        this.jdbcTemplate.getJdbcOperations().update(new PreparedStatementCreator(this, account){
            private final Account account$1;

            /*
             * WARNING - void declaration
             */
            public PreparedStatement createPreparedStatement(Connection conn) throws SQLException {
                void var3_3;
                String sql = "INSERT INTO Accounts (name, with, accountCode, initialBalance, currentBalance) VALUES (?, ?, ?, ?, ?)";
                PreparedStatement ps = conn.prepareStatement(sql, (String[])((Object[])new String[]{"id"}));
                ps.setString(1, (String)this.account$1.name().toRepresentation());
                ps.setString(2, (String)this.account$1.withBank().toRepresentation());
                ps.setString(3, (String)this.account$1.accountCode().toRepresentation());
                ps.setInt(4, BoxesRunTime.unboxToInt((Object)this.account$1.initialBalance().toRepresentation()));
                ps.setInt(5, BoxesRunTime.unboxToInt((Object)this.account$1.currentBalance().toRepresentation()));
                return var3_3;
            }
            {
                this.account$1 = account$1;
            }
        }, (KeyHolder)keyHolder);
        int key = keyHolder.getKey().intValue();
        return new Account(key, account.name(), account.withBank(), account.accountCode(), account.initialBalance(), account.currentBalance());
    }

    private Object createAccountMapper() {
        return new ParameterizedRowMapper<Account>(this){

            public Account mapRow(ResultSet rs, int rowNum) {
                return new Account(rs.getInt("id"), new AccountName(rs.getString("name")), new BankName(rs.getString("with")), new AccountCode(rs.getString("accountCode")), new InitialBalance(rs.getInt("initialBalance")), new CurrentBalance(rs.getInt("currentBalance")));
            }
        };
    }

    public JdbcTemplateAccountsDao(SimpleJdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }
}

