/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.csv;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVRecord;
import org.dflib.ByteSource;
import org.dflib.ByteSources;
import org.dflib.DataFrame;
import org.dflib.DoubleValueMapper;
import org.dflib.Extractor;
import org.dflib.FloatValueMapper;
import org.dflib.Index;
import org.dflib.IntValueMapper;
import org.dflib.LongValueMapper;
import org.dflib.RowPredicate;
import org.dflib.ValueMapper;
import org.dflib.builder.DataFrameAppender;
import org.dflib.builder.DataFrameByRowBuilder;
import org.dflib.collection.Iterators;
import org.dflib.csv.ColConfigurator;
import org.dflib.csv.CsvHeader;
import org.dflib.csv.CsvHeaderFactory;
import org.dflib.csv.CsvSchema;
import org.dflib.csv.CsvSchemaFactory;
import org.dflib.sample.Sampler;

public class CsvLoader {
    private CsvHeaderFactory headerFactory;
    private CsvSchemaFactory schemaFactory;
    private final List<ColConfigurator> colConfigurators;
    private CSVFormat format = CSVFormat.DEFAULT;
    private Charset encoding;
    private RowPredicate rowCondition;
    private int rowSampleSize;
    private Random rowsSampleRandom;
    private int offset;
    private int limit = -1;

    public CsvLoader() {
        this.colConfigurators = new ArrayList<ColConfigurator>();
    }

    public CsvLoader encoding(String encoding) {
        return this.encoding(encoding != null ? Charset.forName(encoding) : null);
    }

    public CsvLoader encoding(Charset encoding) {
        this.encoding = encoding;
        return this;
    }

    public CsvLoader offset(int len) {
        this.offset = len;
        return this;
    }

    public CsvLoader limit(int len) {
        this.limit = len;
        return this;
    }

    public CsvLoader rowsSample(int size) {
        return this.rowsSample(size, Sampler.getDefaultRandom());
    }

    public CsvLoader rowsSample(int size, Random random) {
        this.rowSampleSize = size;
        this.rowsSampleRandom = Objects.requireNonNull(random);
        return this;
    }

    public CsvLoader rows(RowPredicate rowCondition) {
        this.rowCondition = rowCondition;
        return this;
    }

    public CsvLoader header(String ... columns) {
        this.headerFactory = CsvHeaderFactory.explicit(Index.of((String[])columns));
        return this;
    }

    public CsvLoader generateHeader() {
        this.headerFactory = CsvHeaderFactory.generated();
        return this;
    }

    public CsvLoader cols(String ... columns) {
        this.schemaFactory = CsvSchemaFactory.ofCols(columns);
        return this;
    }

    public CsvLoader cols(int ... columns) {
        this.schemaFactory = CsvSchemaFactory.ofCols(columns);
        return this;
    }

    public CsvLoader colsExcept(String ... columns) {
        this.schemaFactory = CsvSchemaFactory.ofColsExcept(columns);
        return this;
    }

    public CsvLoader colsExcept(int ... columns) {
        this.schemaFactory = CsvSchemaFactory.ofColsExcept(columns);
        return this;
    }

    public CsvLoader col(int column, ValueMapper<String, ?> mapper) {
        this.colConfigurators.add(ColConfigurator.objectCol(column, mapper, false));
        return this;
    }

    public CsvLoader col(String column, ValueMapper<String, ?> mapper) {
        this.colConfigurators.add(ColConfigurator.objectCol(column, mapper, false));
        return this;
    }

    public CsvLoader compactCol(int column) {
        this.colConfigurators.add(ColConfigurator.objectCol(column, true));
        return this;
    }

    public CsvLoader compactCol(String column) {
        this.colConfigurators.add(ColConfigurator.objectCol(column, true));
        return this;
    }

    public CsvLoader compactCol(int column, ValueMapper<String, ?> mapper) {
        this.colConfigurators.add(ColConfigurator.objectCol(column, mapper, true));
        return this;
    }

    public CsvLoader compactCol(String column, ValueMapper<String, ?> mapper) {
        this.colConfigurators.add(ColConfigurator.objectCol(column, mapper, true));
        return this;
    }

    public CsvLoader intCol(int column) {
        this.colConfigurators.add(ColConfigurator.intCol(column, (IntValueMapper<String>)IntValueMapper.fromString()));
        return this;
    }

    public CsvLoader intCol(String column) {
        this.colConfigurators.add(ColConfigurator.intCol(column, (IntValueMapper<String>)IntValueMapper.fromString()));
        return this;
    }

    public CsvLoader intCol(int column, int forNull) {
        this.colConfigurators.add(ColConfigurator.intCol(column, (IntValueMapper<String>)IntValueMapper.fromString((int)forNull)));
        return this;
    }

    public CsvLoader intCol(String column, int forNull) {
        this.colConfigurators.add(ColConfigurator.intCol(column, (IntValueMapper<String>)IntValueMapper.fromString((int)forNull)));
        return this;
    }

    public CsvLoader longCol(int column) {
        this.colConfigurators.add(ColConfigurator.longCol(column, (LongValueMapper<String>)LongValueMapper.fromString()));
        return this;
    }

    public CsvLoader longCol(String column) {
        this.colConfigurators.add(ColConfigurator.longCol(column, (LongValueMapper<String>)LongValueMapper.fromString()));
        return this;
    }

    public CsvLoader longCol(int column, long forNull) {
        this.colConfigurators.add(ColConfigurator.longCol(column, (LongValueMapper<String>)LongValueMapper.fromString((long)forNull)));
        return this;
    }

    public CsvLoader longCol(String column, long forNull) {
        this.colConfigurators.add(ColConfigurator.longCol(column, (LongValueMapper<String>)LongValueMapper.fromString((long)forNull)));
        return this;
    }

    public CsvLoader floatCol(int column) {
        this.colConfigurators.add(ColConfigurator.floatCol(column, (FloatValueMapper<String>)FloatValueMapper.fromString()));
        return this;
    }

    public CsvLoader floatCol(String column) {
        this.colConfigurators.add(ColConfigurator.floatCol(column, (FloatValueMapper<String>)FloatValueMapper.fromString()));
        return this;
    }

    public CsvLoader doubleCol(int column) {
        this.colConfigurators.add(ColConfigurator.doubleCol(column, (DoubleValueMapper<String>)DoubleValueMapper.fromString()));
        return this;
    }

    public CsvLoader doubleCol(String column) {
        this.colConfigurators.add(ColConfigurator.doubleCol(column, (DoubleValueMapper<String>)DoubleValueMapper.fromString()));
        return this;
    }

    public CsvLoader doubleCol(int column, double forNull) {
        this.colConfigurators.add(ColConfigurator.doubleCol(column, (DoubleValueMapper<String>)DoubleValueMapper.fromString((double)forNull)));
        return this;
    }

    public CsvLoader doubleCol(String column, double forNull) {
        this.colConfigurators.add(ColConfigurator.doubleCol(column, (DoubleValueMapper<String>)DoubleValueMapper.fromString((double)forNull)));
        return this;
    }

    public CsvLoader decimalCol(int column) {
        this.colConfigurators.add(ColConfigurator.objectCol(column, ValueMapper.stringToBigDecimal(), false));
        return this;
    }

    public CsvLoader decimalCol(String column) {
        this.colConfigurators.add(ColConfigurator.objectCol(column, ValueMapper.stringToBigDecimal(), false));
        return this;
    }

    public CsvLoader boolCol(int column) {
        this.colConfigurators.add(ColConfigurator.boolCol(column));
        return this;
    }

    public CsvLoader boolCol(String column) {
        this.colConfigurators.add(ColConfigurator.boolCol(column));
        return this;
    }

    public CsvLoader numCol(int column, Class<? extends Number> type) {
        return this.col(column, this.numericMapper(type));
    }

    public CsvLoader numCol(String column, Class<? extends Number> type) {
        return this.col(column, this.numericMapper(type));
    }

    private ValueMapper<String, ?> numericMapper(Class<? extends Number> type) {
        if (Integer.class.equals(type)) {
            return ValueMapper.stringToInt();
        }
        if (Long.class.equals(type)) {
            return ValueMapper.stringToLong();
        }
        if (Double.class.equals(type)) {
            return ValueMapper.stringToDouble();
        }
        if (Float.class.equals(type)) {
            return ValueMapper.stringToFloat();
        }
        if (BigDecimal.class.equals(type)) {
            return ValueMapper.stringToBigDecimal();
        }
        if (BigInteger.class.equals(type)) {
            return ValueMapper.stringToBigInteger();
        }
        throw new IllegalArgumentException("Can't map numeric type to a string converter: " + String.valueOf(type));
    }

    public CsvLoader dateCol(int column) {
        return this.col(column, ValueMapper.stringToDate());
    }

    public CsvLoader dateCol(String column) {
        return this.col(column, ValueMapper.stringToDate());
    }

    public CsvLoader dateCol(int column, DateTimeFormatter formatter) {
        return this.col(column, ValueMapper.stringToDate((DateTimeFormatter)formatter));
    }

    public CsvLoader dateCol(String column, DateTimeFormatter formatter) {
        return this.col(column, ValueMapper.stringToDate((DateTimeFormatter)formatter));
    }

    public CsvLoader dateTimeCol(int column) {
        return this.col(column, ValueMapper.stringToDateTime());
    }

    public CsvLoader dateTimeCol(String column) {
        return this.col(column, ValueMapper.stringToDateTime());
    }

    public CsvLoader dateTimeCol(int column, DateTimeFormatter formatter) {
        return this.col(column, ValueMapper.stringToDateTime((DateTimeFormatter)formatter));
    }

    public CsvLoader dateTimeCol(String column, DateTimeFormatter formatter) {
        return this.col(column, ValueMapper.stringToDateTime((DateTimeFormatter)formatter));
    }

    public CsvLoader format(CSVFormat format) {
        this.format = format != null ? format : CSVFormat.DEFAULT;
        return this;
    }

    public CsvLoader emptyStringIsNull() {
        return this.nullString("");
    }

    public CsvLoader nullString(String nullString) {
        this.format = this.format.builder().setNullString(Objects.requireNonNull(nullString)).build();
        return this;
    }

    public DataFrame load(Path filePath) {
        return this.load(filePath.toFile());
    }

    public DataFrame load(File file) {
        DataFrame dataFrame;
        FileInputStream in = new FileInputStream(file);
        try {
            dataFrame = this.load(in, file.getPath());
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)in).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Error reading file: " + String.valueOf(file), e);
            }
        }
        ((InputStream)in).close();
        return dataFrame;
    }

    public DataFrame load(String filePath) {
        DataFrame dataFrame;
        FileInputStream in = new FileInputStream(filePath);
        try {
            dataFrame = this.load(in, filePath);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)in).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Error reading file: " + filePath, e);
            }
        }
        ((InputStream)in).close();
        return dataFrame;
    }

    public DataFrame load(ByteSource src) {
        return (DataFrame)src.processStream(st -> this.load((InputStream)st, "?"));
    }

    public Map<String, DataFrame> loadAll(ByteSources src) {
        return src.processStreams((name, st) -> this.load((InputStream)st, (String)name));
    }

    private DataFrame load(InputStream in, String resourceId) {
        DataFrame dataFrame;
        Charset encoding = this.encoding != null ? this.encoding : Charset.defaultCharset();
        InputStreamReader r = new InputStreamReader(in, encoding);
        try {
            dataFrame = this.load(r);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)r).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Error reading source: " + resourceId, e);
            }
        }
        ((Reader)r).close();
        return dataFrame;
    }

    public DataFrame load(Reader reader) {
        Iterator it2;
        Iterator it0 = this.read(reader);
        Iterator it1 = this.offset > 0 ? Iterators.skip(it0, (int)this.offset) : it0;
        CsvHeader csvHeader = this.createCsvHeader(it1);
        CsvSchema schema = this.createSchema(csvHeader.getHeader());
        CSVRecord maybeUnconsumedDataRow = csvHeader.getMaybeUnconsumedDataRow();
        int limit = this.limit;
        if (limit == 0 || maybeUnconsumedDataRow == null && !it1.hasNext()) {
            return DataFrame.empty((Index)schema.getDfHeader());
        }
        Extractor<CSVRecord, ?>[] extractors = this.extractors(schema);
        DataFrameByRowBuilder builder = DataFrame.byRow(extractors).columnIndex(schema.getDfHeader());
        if (this.rowSampleSize > 0) {
            builder.sampleRows(this.rowSampleSize, this.rowsSampleRandom);
        }
        if (this.rowCondition != null) {
            builder.selectRows(this.rowCondition);
        }
        DataFrameAppender appender = builder.appender();
        if (maybeUnconsumedDataRow != null) {
            appender.append((Object)maybeUnconsumedDataRow);
            --limit;
        }
        Iterator iterator = it2 = limit >= 0 ? Iterators.limit((Iterator)it1, (int)limit) : it1;
        while (it2.hasNext()) {
            appender.append((Object)((CSVRecord)it2.next()));
        }
        return appender.toDataFrame();
    }

    private Iterator<CSVRecord> read(Reader reader) {
        try {
            return this.format.parse(reader).iterator();
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading CSV", e);
        }
    }

    private CsvSchema createSchema(Index csvHeader) {
        return this.schemaFactory != null ? this.schemaFactory.schema(csvHeader) : CsvSchemaFactory.all().schema(csvHeader);
    }

    private CsvHeader createCsvHeader(Iterator<CSVRecord> it) {
        return this.headerFactory != null ? this.headerFactory.header(it) : CsvHeaderFactory.firstRow().header(it);
    }

    private Extractor<CSVRecord, ?>[] extractors(CsvSchema schema) {
        Index csvHeader = schema.getCsvHeader();
        int[] csvPositions = schema.getCsvPositions();
        int w = schema.getDfHeader().size();
        Extractor[] extractors = new Extractor[w];
        HashMap<Integer, ColConfigurator> configurators = new HashMap<Integer, ColConfigurator>();
        for (ColConfigurator c : this.colConfigurators) {
            int csvPos = c.srcColPos >= 0 ? c.srcColPos : csvHeader.position(c.srcColName);
            configurators.put(csvPos, c);
        }
        for (int i = 0; i < w; ++i) {
            int csvPos = csvPositions[i];
            ColConfigurator cc = configurators.computeIfAbsent(csvPos, ii -> ColConfigurator.objectCol(ii, false));
            extractors[i] = cc.extractor(csvHeader);
        }
        return extractors;
    }
}

