/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jdbc.connector;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.dflib.Extractor;
import org.dflib.Index;
import org.dflib.jdbc.connector.JdbcConnector;

class ColConfigurator {
    int srcColPos = -1;
    String srcColName;
    boolean compact;

    private ColConfigurator() {
    }

    static ColConfigurator objectCol(int pos, boolean compact) {
        ColConfigurator config = new ColConfigurator();
        config.srcColPos = pos;
        config.compact = compact;
        return config;
    }

    static ColConfigurator objectCol(String name, boolean compact) {
        ColConfigurator config = new ColConfigurator();
        config.srcColName = name;
        config.compact = compact;
        return config;
    }

    int srcPos(Index header) {
        return this.srcColPos >= 0 ? this.srcColPos : header.position(this.srcColName);
    }

    Extractor<ResultSet, ?> extractor(int srcPos, JdbcConnector connector, ResultSetMetaData schema) throws SQLException {
        Extractor e = ColConfigurator.sparseExtractor(srcPos, connector, schema);
        return this.compact ? e.compact() : e;
    }

    private static Extractor<ResultSet, ?> sparseExtractor(int pos, JdbcConnector connector, ResultSetMetaData schema) throws SQLException {
        int jdbcPos = pos + 1;
        return connector.createExtractor(jdbcPos, schema.getColumnType(jdbcPos), schema.isNullable(jdbcPos) == 0);
    }
}

