/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jdbc.connector;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.dflib.Extractor;
import org.dflib.Printers;
import org.dflib.jdbc.connector.IdentifierQuoter;
import org.dflib.jdbc.connector.JdbcConnector;
import org.dflib.jdbc.connector.SqlLoader;
import org.dflib.jdbc.connector.SqlLogger;
import org.dflib.jdbc.connector.SqlSaver;
import org.dflib.jdbc.connector.StatementBuilder;
import org.dflib.jdbc.connector.TableDeleter;
import org.dflib.jdbc.connector.TableLoader;
import org.dflib.jdbc.connector.TableSaver;
import org.dflib.jdbc.connector.loader.JdbcExtractorFactory;
import org.dflib.jdbc.connector.metadata.DbMetadata;
import org.dflib.jdbc.connector.metadata.TableFQName;
import org.dflib.jdbc.connector.statement.ValueConverter;
import org.dflib.jdbc.connector.statement.ValueConverterFactory;

public class DefaultJdbcConnector
implements JdbcConnector {
    private final DataSource dataSource;
    private final DbMetadata metadata;
    private final IdentifierQuoter quoter;
    private final JdbcExtractorFactory defaultExtractorFactory;
    private final Map<Integer, JdbcExtractorFactory> primitiveExtractorFactories;
    private final Map<Integer, JdbcExtractorFactory> extractorFactories;
    private final ValueConverterFactory preBindConverterFactory;
    private final SqlLogger sqlLogger;

    public DefaultJdbcConnector(DataSource dataSource, DbMetadata metadata, Map<Integer, JdbcExtractorFactory> extractorFactories) {
        this.dataSource = dataSource;
        this.metadata = metadata;
        this.defaultExtractorFactory = JdbcExtractorFactory::$col;
        this.primitiveExtractorFactories = new HashMap<Integer, JdbcExtractorFactory>();
        this.primitiveExtractorFactories.put(16, JdbcExtractorFactory::$bool);
        this.primitiveExtractorFactories.put(4, JdbcExtractorFactory::$int);
        this.primitiveExtractorFactories.put(8, JdbcExtractorFactory::$double);
        this.primitiveExtractorFactories.put(6, JdbcExtractorFactory::$double);
        this.primitiveExtractorFactories.put(-5, JdbcExtractorFactory::$long);
        this.primitiveExtractorFactories.put(-7, JdbcExtractorFactory::$bool);
        this.extractorFactories = extractorFactories;
        this.preBindConverterFactory = this.createPreBindConverterFactory();
        this.quoter = this.createQuoter();
        this.sqlLogger = this.createSqlLogger();
    }

    protected ValueConverterFactory createPreBindConverterFactory() {
        HashMap<Integer, ValueConverter> converters = new HashMap<Integer, ValueConverter>();
        converters.put(91, ValueConverter.dateConverter());
        converters.put(92, ValueConverter.timeConverter());
        converters.put(93, ValueConverter.timestampConverter());
        converters.put(4, ValueConverter.intConverter());
        converters.put(12, ValueConverter.stringConverter());
        return new ValueConverterFactory(ValueConverter.defaultConverter(), converters);
    }

    protected SqlLogger createSqlLogger() {
        return new SqlLogger(Printers.inline);
    }

    @Override
    public TableSaver tableSaver(String tableName) {
        return this.tableSaver(this.getMetadata().parseTableName(tableName));
    }

    @Override
    public TableSaver tableSaver(TableFQName tableName) {
        return new TableSaver(this, tableName);
    }

    @Override
    public TableLoader tableLoader(String tableName) {
        return this.tableLoader(this.getMetadata().parseTableName(tableName));
    }

    @Override
    public TableLoader tableLoader(TableFQName tableName) {
        return new TableLoader(this, tableName);
    }

    @Override
    public TableDeleter tableDeleter(TableFQName tableName) {
        return new TableDeleter(this, tableName);
    }

    @Override
    public TableDeleter tableDeleter(String tableName) {
        return this.tableDeleter(this.getMetadata().parseTableName(tableName));
    }

    @Override
    public SqlLoader sqlLoader(String sql) {
        return new SqlLoader(this, sql);
    }

    @Override
    public SqlSaver sqlSaver(String sql) {
        return new SqlSaver(this, sql);
    }

    @Override
    public Extractor<ResultSet, ?> createExtractor(int resultSetPosition, int type, boolean mandatory) {
        JdbcExtractorFactory factory = null;
        if (mandatory) {
            factory = this.primitiveExtractorFactories.get(type);
        }
        if (factory == null) {
            factory = this.extractorFactories.getOrDefault(type, this.defaultExtractorFactory);
        }
        return factory.createExtractor(resultSetPosition);
    }

    @Override
    public StatementBuilder createStatementBuilder(String sql) {
        return new StatementBuilder(this).sql(sql);
    }

    @Override
    public ValueConverterFactory getBindConverterFactory() {
        return this.preBindConverterFactory;
    }

    @Override
    public DbMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public SqlLogger getSqlLogger() {
        return this.sqlLogger;
    }

    @Override
    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public Connection getConnection() {
        Connection connection;
        try {
            connection = this.dataSource.getConnection();
        }
        catch (SQLException e) {
            throw new RuntimeException("Error opening connection", e);
        }
        try {
            connection.setAutoCommit(false);
        }
        catch (SQLException e) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw new RuntimeException("Error setting connection auto commit to 'false'", e);
        }
        return connection;
    }

    @Override
    public String quoteIdentifier(String bareIdentifier) {
        return this.quoter.quoted(bareIdentifier);
    }

    @Override
    public String quoteTableName(TableFQName tableName) {
        String qtn = this.quoter.quoted(tableName.getTable());
        if (!tableName.hasCatalog() && !tableName.hasSchema()) {
            return qtn;
        }
        StringBuilder buffer = new StringBuilder();
        if (tableName.hasCatalog()) {
            buffer.append(this.quoter.quoted(tableName.getCatalog())).append(".");
        }
        if (tableName.hasSchema()) {
            buffer.append(this.quoter.quoted(tableName.getSchema())).append(".");
        }
        return buffer.append(qtn).toString();
    }

    protected IdentifierQuoter createQuoter() {
        String identifierQuote = this.getMetadata().getIdentifierQuote();
        return " ".equals(identifierQuote) ? IdentifierQuoter.noQuote() : IdentifierQuoter.forQuoteSymbol(identifierQuote);
    }
}

