/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jdbc.connector;

import java.sql.Driver;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.sql.DataSource;
import org.dflib.jdbc.connector.DefaultJdbcConnector;
import org.dflib.jdbc.connector.JdbcConnector;
import org.dflib.jdbc.connector.loader.JdbcExtractorFactory;
import org.dflib.jdbc.connector.metadata.DbMetadata;
import org.dflib.jdbc.datasource.SimpleDataSource;

public class JdbcConnectorBuilder {
    private String userName;
    private String password;
    private String driver;
    private String url;
    private DataSource dataSource;
    private Map<Integer, JdbcExtractorFactory> columnBuilderFactories;

    public JdbcConnectorBuilder url(String url) {
        this.url = url;
        return this;
    }

    public JdbcConnectorBuilder userName(String userName) {
        this.dataSource = null;
        this.userName = userName;
        return this;
    }

    public JdbcConnectorBuilder password(String password) {
        this.dataSource = null;
        this.password = password;
        return this;
    }

    public JdbcConnectorBuilder driver(String driverClassName) {
        this.dataSource = null;
        this.driver = driverClassName;
        return this;
    }

    public JdbcConnectorBuilder dataSource(DataSource dataSource) {
        this.dataSource = Objects.requireNonNull(dataSource);
        this.userName = null;
        this.password = null;
        this.driver = null;
        this.url = null;
        return this;
    }

    public <T> JdbcConnectorBuilder addColumnBuilderFactory(int columnJdbcType, JdbcExtractorFactory<T> factory) {
        if (this.columnBuilderFactories == null) {
            this.columnBuilderFactories = new HashMap<Integer, JdbcExtractorFactory>();
        }
        this.columnBuilderFactories.put(columnJdbcType, factory);
        return this;
    }

    public JdbcConnector build() {
        DataSource dataSource = this.dataSource != null ? this.dataSource : this.createDataSource();
        return new DefaultJdbcConnector(dataSource, DbMetadata.create(dataSource), this.createColumnBuilderFactories());
    }

    private Map<Integer, JdbcExtractorFactory> createColumnBuilderFactories() {
        HashMap<Integer, JdbcExtractorFactory> factories = new HashMap<Integer, JdbcExtractorFactory>();
        factories.put(91, JdbcExtractorFactory::$date);
        factories.put(92, JdbcExtractorFactory::$time);
        factories.put(93, JdbcExtractorFactory::$datetime);
        if (this.columnBuilderFactories != null) {
            factories.putAll(this.columnBuilderFactories);
        }
        return factories;
    }

    private DataSource createDataSource() {
        Driver driver = this.createDriver();
        return new SimpleDataSource(this.url, this.userName, this.password, driver);
    }

    private Driver createDriver() {
        if (this.driver == null) {
            return null;
        }
        try {
            return (Driver)Class.forName(this.driver).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Error instantiating driver: " + this.driver, e);
        }
    }
}

