/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jdbc.connector;

import java.util.LinkedHashMap;
import java.util.function.Supplier;
import org.dflib.DataFrame;
import org.dflib.Series;
import org.dflib.SeriesGroupBy;
import org.dflib.jdbc.SaveOp;

public class SaveStats {
    private Supplier<Series<SaveOp>> statsSupplier;
    private volatile Series<SaveOp> rowSaveStatuses;
    private volatile SeriesGroupBy<SaveOp> rowSaveStatusesByOp;

    public SaveStats(Supplier<Series<SaveOp>> statsSupplier) {
        this.statsSupplier = statsSupplier;
    }

    public DataFrame changedRows(DataFrame savedDf) {
        return savedDf.rows(this.getRowSaveStatuses().index(op -> op != SaveOp.skip)).select();
    }

    public Series<SaveOp> getRowSaveStatuses() {
        if (this.rowSaveStatuses == null) {
            this.rowSaveStatuses = this.statsSupplier.get();
        }
        return this.rowSaveStatuses;
    }

    public int getInsertCount() {
        return this.getOpCount(SaveOp.insert);
    }

    public int getUpdateCount() {
        return this.getOpCount(SaveOp.update);
    }

    public int getSkipCount() {
        return this.getOpCount(SaveOp.skip);
    }

    protected int getOpCount(SaveOp op) {
        if (this.rowSaveStatusesByOp == null) {
            this.rowSaveStatusesByOp = this.getRowSaveStatuses().group();
        }
        return this.rowSaveStatusesByOp.hasGroup((Object)op) ? this.rowSaveStatusesByOp.getGroup((Object)op).size() : 0;
    }

    public String toString() {
        LinkedHashMap<String, Integer> map = new LinkedHashMap<String, Integer>(5);
        map.put("inserted", this.getInsertCount());
        map.put("updated", this.getUpdateCount());
        map.put("unchanged", this.getSkipCount());
        return ((Object)map).toString();
    }
}

