/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jdbc.connector;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import org.dflib.DataFrame;
import org.dflib.Extractor;
import org.dflib.Index;
import org.dflib.Series;
import org.dflib.builder.DataFrameAppender;
import org.dflib.jdbc.connector.ColConfigurator;
import org.dflib.jdbc.connector.JdbcConnector;
import org.dflib.jdbc.connector.SqlLoaderWorker;
import org.dflib.sample.Sampler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(SqlLoader.class);
    protected final JdbcConnector connector;
    private final String sql;
    private final List<ColConfigurator> colConfigurators;
    protected int limit;
    private int rowSampleSize;
    private Random rowsSampleRandom;

    public SqlLoader(JdbcConnector connector, String sql) {
        this.connector = connector;
        this.limit = Integer.MAX_VALUE;
        this.sql = sql;
        this.colConfigurators = new ArrayList<ColConfigurator>();
    }

    protected SqlLoader copy() {
        SqlLoader copy = new SqlLoader(this.connector, this.sql);
        copy.limit = this.limit;
        copy.rowSampleSize = this.rowSampleSize;
        copy.rowsSampleRandom = this.rowsSampleRandom;
        copy.colConfigurators.addAll(this.colConfigurators);
        return copy;
    }

    SqlLoader colConfigurators(List<ColConfigurator> configurators) {
        this.colConfigurators.addAll(configurators);
        return this;
    }

    public SqlLoader compactCol(int column) {
        this.colConfigurators.add(ColConfigurator.objectCol(column, true));
        return this;
    }

    public SqlLoader compactCol(String column) {
        this.colConfigurators.add(ColConfigurator.objectCol(column, true));
        return this;
    }

    public SqlLoader limit(int limit) {
        if (this.limit == limit) {
            return this;
        }
        SqlLoader copy = this.copy();
        copy.limit = limit;
        return copy;
    }

    public SqlLoader rowsSample(int size) {
        return this.rowsSample(size, Sampler.getDefaultRandom());
    }

    public SqlLoader rowsSample(int size, Random random) {
        if (this.rowSampleSize == size && this.rowsSampleRandom == random) {
            return this;
        }
        SqlLoader copy = this.copy();
        copy.rowSampleSize = size;
        copy.rowsSampleRandom = random;
        return copy;
    }

    public DataFrame load(Object ... params) {
        return this.load(Series.of((Object[])params));
    }

    public DataFrame load(Series<?> params) {
        LOGGER.debug("loading DataFrame...");
        return this.connector.createStatementBuilder(this.sql).bind(params).select(this::loadDataFrame);
    }

    protected DataFrame loadDataFrame(ResultSet rs) throws SQLException {
        Index index = this.createIndex(rs);
        Extractor<ResultSet, ?>[] extractors = this.extractors(index, rs);
        DataFrameAppender appender = DataFrame.byRow(extractors).columnIndex(index).capacity(this.rowSampleSize > 0 ? this.rowSampleSize : 100).sampleRows(this.rowSampleSize, this.rowsSampleRandom).appender();
        return new SqlLoaderWorker((DataFrameAppender<ResultSet>)appender, this.limit).load(rs);
    }

    protected Index createIndex(ResultSet rs) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int width = rsmd.getColumnCount();
        String[] names = new String[width];
        for (int i = 0; i < width; ++i) {
            names[i] = rsmd.getColumnLabel(i + 1);
        }
        return Index.of((String[])names);
    }

    protected Extractor<ResultSet, ?>[] extractors(Index index, ResultSet resultSet) throws SQLException {
        HashMap<Integer, ColConfigurator> configurators = new HashMap<Integer, ColConfigurator>();
        for (ColConfigurator c : this.colConfigurators) {
            configurators.put(c.srcPos(index), c);
        }
        ResultSetMetaData schema = resultSet.getMetaData();
        int w = schema.getColumnCount();
        Extractor[] extractors = new Extractor[w];
        for (int i = 0; i < w; ++i) {
            ColConfigurator cc = configurators.computeIfAbsent(i, ii -> ColConfigurator.objectCol(ii, false));
            extractors[i] = cc.extractor(i, this.connector, schema);
        }
        return extractors;
    }
}

