/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jdbc.connector;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.dflib.DataFrame;
import org.dflib.builder.DataFrameAppender;

class SqlLoaderWorker {
    protected final DataFrameAppender<ResultSet> appender;
    protected final int limit;

    public SqlLoaderWorker(DataFrameAppender<ResultSet> appender, int limit) {
        this.limit = limit < 0 ? Integer.MAX_VALUE : limit;
        this.appender = appender;
    }

    DataFrame load(ResultSet rs) throws SQLException {
        this.consumeResultSet(rs);
        return this.toDataFrame();
    }

    protected void consumeResultSet(ResultSet rs) throws SQLException {
        int size = 0;
        while (rs.next() && size++ < this.limit) {
            this.appender.append((Object)rs);
        }
    }

    protected DataFrame toDataFrame() {
        return this.appender.toDataFrame();
    }
}

