/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jdbc.connector;

import org.dflib.DataFrame;
import org.dflib.Series;
import org.dflib.jdbc.connector.JdbcConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlSaver {
    private static final Logger LOGGER = LoggerFactory.getLogger(SqlSaver.class);
    protected JdbcConnector connector;
    private String sql;

    public SqlSaver(JdbcConnector connector, String sql) {
        this.connector = connector;
        this.sql = sql;
    }

    public int[] save(DataFrame data) {
        LOGGER.debug("saving DataFrame data...");
        return this.connector.createStatementBuilder(this.sql).bindBatch(data).update();
    }

    public int save(Series<?> data) {
        LOGGER.debug("saving Series data...");
        int[] updateCounts = this.connector.createStatementBuilder(this.sql).bind(data).update();
        return updateCounts[0];
    }

    public int save(Object ... data) {
        LOGGER.debug("saving array data...");
        int[] updateCounts = this.connector.createStatementBuilder(this.sql).bind(data).update();
        return updateCounts[0];
    }
}

