/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jdbc.connector;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.dflib.DataFrame;
import org.dflib.Series;
import org.dflib.jdbc.connector.JdbcConnector;
import org.dflib.jdbc.connector.JdbcFunction;
import org.dflib.jdbc.connector.metadata.DbColumnMetadata;
import org.dflib.jdbc.connector.statement.CompiledFromStatementBinderFactory;
import org.dflib.jdbc.connector.statement.FixedParamsBinderFactory;
import org.dflib.jdbc.connector.statement.SelectStatement;
import org.dflib.jdbc.connector.statement.SelectStatementNoParams;
import org.dflib.jdbc.connector.statement.SelectStatementWithParams;
import org.dflib.jdbc.connector.statement.StatementBinderFactory;
import org.dflib.jdbc.connector.statement.UpdateStatement;
import org.dflib.jdbc.connector.statement.UpdateStatementBatch;
import org.dflib.jdbc.connector.statement.UpdateStatementNoBatch;
import org.dflib.jdbc.connector.statement.UpdateStatementNoParams;
import org.dflib.jdbc.connector.statement.UpdateStatementParamsRow;

public class StatementBuilder {
    private JdbcConnector connector;
    private String sql;
    private DbColumnMetadata[] paramDescriptors;
    private Series<?> params;
    private DataFrame batchParams;

    public StatementBuilder(JdbcConnector connector) {
        this.connector = connector;
    }

    public StatementBuilder sql(String sql) {
        this.sql = sql;
        return this;
    }

    public StatementBuilder paramDescriptors(DbColumnMetadata[] paramDescriptors) {
        this.paramDescriptors = paramDescriptors;
        return this;
    }

    public StatementBuilder bindBatch(DataFrame batchParams) {
        this.params = null;
        this.batchParams = batchParams;
        return this;
    }

    public StatementBuilder bind(Series<?> params) {
        this.params = params;
        this.batchParams = null;
        return this;
    }

    public StatementBuilder bind(Object[] params) {
        return this.bind(Series.of((Object[])params));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T select(JdbcFunction<ResultSet, T> resultReader) {
        try (Connection c = this.connector.getConnection();){
            T t = this.select(c, resultReader);
            return t;
        }
        catch (SQLException e) {
            throw new RuntimeException("Error opening connection: " + e.getMessage(), e);
        }
    }

    public <T> T select(Connection connection, JdbcFunction<ResultSet, T> resultReader) {
        try {
            return this.createSelectStatement().select(connection, resultReader);
        }
        catch (SQLException e) {
            throw new RuntimeException("Error loading data from DB: " + e.getMessage(), e);
        }
    }

    public int[] update() {
        int[] updateCounts;
        if (this.params == null && this.batchParams != null && this.batchParams.height() == 0) {
            return new int[0];
        }
        try (Connection c = this.connector.getConnection();){
            updateCounts = this.update(c);
            c.commit();
        }
        catch (SQLException e) {
            throw new RuntimeException("Error opening connection: " + e.getMessage(), e);
        }
        return updateCounts;
    }

    public int[] update(Connection connection) {
        try {
            return this.createUpdateStatement().update(connection);
        }
        catch (SQLException e) {
            throw new RuntimeException("Error updating data in DB: " + e.getMessage(), e);
        }
    }

    protected SelectStatement createSelectStatement() {
        if (this.batchParams != null) {
            throw new IllegalStateException("Can't use batch params for 'select'");
        }
        return this.params == null || this.params.size() == 0 ? new SelectStatementNoParams(this.sql, this.connector.getSqlLogger()) : new SelectStatementWithParams(this.sql, this.params, this.createBinderFactory(), this.connector.getSqlLogger());
    }

    protected UpdateStatement createUpdateStatement() {
        if (this.params != null) {
            return new UpdateStatementParamsRow(this.sql, this.params, this.createBinderFactory(), this.connector.getSqlLogger());
        }
        if (this.batchParams != null) {
            return this.connector.getMetadata().supportsBatchUpdates() ? new UpdateStatementBatch(this.sql, this.batchParams, this.createBinderFactory(), this.connector.getSqlLogger()) : new UpdateStatementNoBatch(this.sql, this.batchParams, this.createBinderFactory(), this.connector.getSqlLogger());
        }
        return new UpdateStatementNoParams(this.sql, this.connector.getSqlLogger());
    }

    protected StatementBinderFactory createBinderFactory() {
        return this.paramDescriptors != null ? new FixedParamsBinderFactory(this.connector.getBindConverterFactory(), this.paramDescriptors) : new CompiledFromStatementBinderFactory(this.connector.getMetadata().getFlavor(), this.connector.getBindConverterFactory());
    }
}

