/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jdbc.connector;

import java.util.Objects;
import org.dflib.DataFrame;
import org.dflib.jdbc.connector.JdbcConnector;
import org.dflib.jdbc.connector.SqlSaver;
import org.dflib.jdbc.connector.condition.ConditionBuilder;
import org.dflib.jdbc.connector.metadata.TableFQName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableDeleter {
    private static final Logger LOGGER = LoggerFactory.getLogger(TableDeleter.class);
    protected JdbcConnector connector;
    private TableFQName tableName;
    private ConditionBuilder condition;

    public TableDeleter(JdbcConnector connector, TableFQName tableName) {
        this.connector = Objects.requireNonNull(connector);
        this.tableName = Objects.requireNonNull(tableName);
        this.condition = new ConditionBuilder(connector);
    }

    public TableDeleter eq(DataFrame condition) {
        this.condition.condition(condition, false);
        return this;
    }

    public TableDeleter neq(DataFrame condition) {
        this.condition.condition(condition, true);
        return this;
    }

    public int delete() {
        if (this.condition.noCondition()) {
            return this.deleteAll();
        }
        if (this.condition.nonEmptyCondition()) {
            return this.deleteConditional();
        }
        return this.deleteEmptyCondition();
    }

    protected int deleteAll() {
        LOGGER.debug("deleting all rows in '{}'", (Object)this.tableName);
        String sql = this.createUnqualifiedDeleteStatement(new StringBuilder()).toString();
        return new SqlSaver(this.connector, sql).save(new Object[0]);
    }

    protected int deleteConditional() {
        LOGGER.debug("deleting rows in '{}' {}matching DataFrame...", (Object)this.tableName, (Object)(this.condition.negatedCondition() ? "not " : " "));
        String sql = this.createDeleteStatement(new StringBuilder()).toString();
        return new SqlSaver(this.connector, sql).save(this.condition.bindingParams());
    }

    protected int deleteEmptyCondition() {
        return this.condition.negatedCondition() ? this.deleteAll() : 0;
    }

    protected StringBuilder createUnqualifiedDeleteStatement(StringBuilder buffer) {
        return buffer.append("delete from " + this.connector.quoteTableName(this.tableName));
    }

    protected StringBuilder createDeleteStatement(StringBuilder buffer) {
        this.createUnqualifiedDeleteStatement(buffer).append(" where ");
        this.condition.toSqlCondition(buffer);
        return buffer;
    }
}

