/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jdbc.connector;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import org.dflib.DataFrame;
import org.dflib.jdbc.connector.ColConfigurator;
import org.dflib.jdbc.connector.JdbcConnector;
import org.dflib.jdbc.connector.SqlLoader;
import org.dflib.jdbc.connector.condition.ConditionBuilder;
import org.dflib.jdbc.connector.metadata.TableFQName;
import org.dflib.sample.Sampler;

public class TableLoader {
    protected JdbcConnector connector;
    protected int limit = -1;
    private TableFQName tableName;
    private String[] columns;
    private ConditionBuilder condition;
    private int rowSampleSize;
    private Random rowsSampleRandom;
    private final List<ColConfigurator> colConfigurators;

    public TableLoader(JdbcConnector connector, TableFQName tableName) {
        this.connector = connector;
        this.tableName = tableName;
        this.condition = new ConditionBuilder(connector);
        this.colConfigurators = new ArrayList<ColConfigurator>();
    }

    public TableLoader cols(String ... columns) {
        this.columns = columns;
        return this;
    }

    public TableLoader compactCol(int column) {
        this.colConfigurators.add(ColConfigurator.objectCol(column, true));
        return this;
    }

    public TableLoader compactCol(String column) {
        this.colConfigurators.add(ColConfigurator.objectCol(column, true));
        return this;
    }

    public TableLoader eq(DataFrame condition) {
        this.condition.condition(condition, false);
        return this;
    }

    public TableLoader neq(DataFrame condition) {
        this.condition.condition(condition, true);
        return this;
    }

    public TableLoader limit(int limit) {
        this.limit = limit;
        return this;
    }

    public TableLoader rowsSample(int size) {
        return this.rowsSample(size, Sampler.getDefaultRandom());
    }

    public TableLoader rowsSample(int size, Random random) {
        this.rowSampleSize = size;
        this.rowsSampleRandom = Objects.requireNonNull(random);
        return this;
    }

    public DataFrame load() {
        return this.condition.noCondition() || this.condition.nonEmptyCondition() ? this.fetchDataFrame() : this.createEmptyDataFrame();
    }

    protected DataFrame createEmptyDataFrame() {
        String[] columns = this.useStandardColumns() ? this.connector.getMetadata().getTable(this.tableName).getColumnNames() : this.columns;
        return DataFrame.empty((String[])columns);
    }

    protected DataFrame fetchDataFrame() {
        return new SqlLoader(this.connector, this.buildSql()).colConfigurators(this.colConfigurators).limit(this.limit).rowsSample(this.rowSampleSize, this.rowsSampleRandom).load(this.condition.bindingParams());
    }

    protected String buildSql() {
        StringBuilder sql = new StringBuilder("select ");
        this.appendColumnsSql(sql);
        sql.append(" from ").append(this.connector.quoteTableName(this.tableName));
        this.appendWhereSql(sql);
        return sql.toString();
    }

    protected StringBuilder appendColumnsSql(StringBuilder buffer) {
        if (this.useStandardColumns()) {
            return buffer.append("*");
        }
        for (int i = 0; i < this.columns.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(this.connector.quoteIdentifier(this.columns[i]));
        }
        return buffer;
    }

    protected boolean useStandardColumns() {
        return this.columns == null || this.columns.length == 0;
    }

    protected StringBuilder appendWhereSql(StringBuilder buffer) {
        if (this.condition.nonEmptyCondition()) {
            buffer.append(" where ");
            this.condition.toSqlCondition(buffer);
        }
        return buffer;
    }
}

