/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jdbc.connector;

import java.util.Objects;
import org.dflib.DataFrame;
import org.dflib.jdbc.connector.JdbcConnector;
import org.dflib.jdbc.connector.SaveStats;
import org.dflib.jdbc.connector.metadata.DbColumnMetadata;
import org.dflib.jdbc.connector.metadata.TableFQName;
import org.dflib.jdbc.connector.saver.SaveViaDeleteThenInsert;
import org.dflib.jdbc.connector.saver.SaveViaDeleteThenUpsert;
import org.dflib.jdbc.connector.saver.SaveViaInsert;
import org.dflib.jdbc.connector.saver.SaveViaUpsert;
import org.dflib.jdbc.connector.saver.TableSaveStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableSaver {
    private static final Logger LOGGER = LoggerFactory.getLogger(TableSaver.class);
    protected JdbcConnector connector;
    private TableFQName tableName;
    private boolean deleteTableData;
    private boolean deleteUnmatchedRows;
    private boolean mergeByPk;
    private String[] mergeByColumns;
    private int batchSize;

    public TableSaver(JdbcConnector connector, TableFQName tableName) {
        this.connector = connector;
        this.tableName = tableName;
    }

    public TableSaver batchSize(int rows) {
        this.batchSize = rows;
        return this;
    }

    public TableSaver deleteTableData() {
        this.deleteTableData = true;
        return this;
    }

    public TableSaver deleteUnmatchedRows() {
        this.deleteUnmatchedRows = true;
        return this;
    }

    public TableSaver mergeByPk() {
        this.mergeByPk = true;
        this.mergeByColumns = null;
        return this;
    }

    public TableSaver mergeByColumns(String ... columns) {
        this.mergeByPk = false;
        this.mergeByColumns = Objects.requireNonNull(columns);
        if (columns.length == 0) {
            throw new IllegalArgumentException("Empty 'mergeBy' columns");
        }
        return this;
    }

    public SaveStats save(DataFrame df) {
        LOGGER.debug("saving DataFrame...");
        return new SaveStats(this.createSaveStrategy().save(df));
    }

    protected TableSaveStrategy createSaveStrategy() {
        String[] keyColumns;
        if (this.deleteTableData) {
            return new SaveViaDeleteThenInsert(this.connector, this.tableName, this.batchSize);
        }
        if (!this.mergeByPk && this.mergeByColumns == null) {
            return new SaveViaInsert(this.connector, this.tableName, this.batchSize);
        }
        String[] stringArray = keyColumns = this.mergeByPk ? this.getPkColumns() : this.mergeByColumns;
        if (this.deleteUnmatchedRows && this.batchSize > 0) {
            LOGGER.warn("'batchSize' will be ignored, as 'deleteUnmatchedRows' is in use");
        }
        return this.deleteUnmatchedRows ? new SaveViaDeleteThenUpsert(this.connector, this.tableName, keyColumns) : new SaveViaUpsert(this.connector, this.tableName, keyColumns, this.batchSize);
    }

    protected String[] getPkColumns() {
        DbColumnMetadata[] pk = this.connector.getMetadata().getTable(this.tableName).getPkColumns();
        int len = pk.length;
        if (len == 0) {
            throw new IllegalStateException("Table '" + this.tableName + "' does not define a PK");
        }
        String[] pkNames = new String[len];
        for (int i = 0; i < len; ++i) {
            pkNames[i] = pk[i].getName();
        }
        return pkNames;
    }
}

