/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jdbc.connector.condition;

import java.util.Objects;
import org.dflib.DataFrame;
import org.dflib.Index;
import org.dflib.Series;
import org.dflib.jdbc.connector.JdbcConnector;
import org.dflib.series.ByRowSeries;

public class ConditionBuilder {
    private JdbcConnector connector;
    private DataFrame condition;
    private boolean negateCondition;

    public ConditionBuilder(JdbcConnector connector) {
        this.connector = connector;
    }

    public ConditionBuilder condition(DataFrame condition, boolean negate) {
        this.condition = Objects.requireNonNull(condition);
        this.negateCondition = negate;
        return this;
    }

    public boolean noCondition() {
        return this.condition == null;
    }

    public boolean nonEmptyCondition() {
        return this.condition != null && this.condition.height() > 0;
    }

    public boolean negatedCondition() {
        return this.negateCondition;
    }

    public StringBuilder toSqlCondition(StringBuilder buffer) {
        int criteriaHeight;
        int n = criteriaHeight = this.condition != null ? this.condition.height() : 0;
        if (criteriaHeight == 0) {
            return buffer;
        }
        int criteriaWidth = this.condition != null ? this.condition.width() : 0;
        switch (criteriaWidth) {
            case 0: {
                return buffer;
            }
            case 1: {
                return this.appendWhereSql_SingleColumn(buffer, this.condition.getColumnsIndex().get(0), criteriaHeight);
            }
        }
        return this.appendWhereSql_MultiColumns(buffer, this.condition.getColumnsIndex(), criteriaHeight);
    }

    public Series<?> bindingParams() {
        int criteriaHeight;
        int n = criteriaHeight = this.condition != null ? this.condition.height() : 0;
        if (criteriaHeight == 0) {
            return Series.of((Object[])new Object[0]);
        }
        int criteriaWidth = this.condition != null ? this.condition.width() : 0;
        switch (criteriaWidth) {
            case 0: {
                return Series.of((Object[])new Object[0]);
            }
            case 1: {
                return this.condition.getColumn(0);
            }
        }
        return new ByRowSeries(this.condition);
    }

    protected StringBuilder appendWhereSql_SingleColumn(StringBuilder buffer, String columnName, int criteriaHeight) {
        buffer.append(this.connector.quoteIdentifier(columnName)).append(this.negateCondition ? " not in" : " in").append(" (?");
        for (int i = 1; i < criteriaHeight; ++i) {
            buffer.append(", ?");
        }
        return buffer.append(")");
    }

    protected StringBuilder appendWhereSql_MultiColumns(StringBuilder buffer, Index columnsIndex, int criteriaHeight) {
        String part = this.singleMultiColumnCondition(columnsIndex);
        buffer.append(this.negateCondition ? " not (" : "").append(part);
        for (int i = 1; i < criteriaHeight; ++i) {
            buffer.append(" or ").append(part);
        }
        buffer.append(this.negateCondition ? ")" : "");
        return buffer;
    }

    private String singleMultiColumnCondition(Index columnsIndex) {
        int w = columnsIndex.size();
        String[] columns = new String[w];
        for (int i = 0; i < w; ++i) {
            columns[i] = this.connector.quoteIdentifier(columnsIndex.get(i));
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("(");
        for (int i = 0; i < w; ++i) {
            if (i > 0) {
                buffer.append(" and ");
            }
            buffer.append(columns[i]).append(" = ?");
        }
        buffer.append(")");
        return buffer.toString();
    }
}

