/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jdbc.connector.loader;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Calendar;
import org.dflib.BoolValueMapper;
import org.dflib.DoubleValueMapper;
import org.dflib.Extractor;
import org.dflib.IntValueMapper;
import org.dflib.LongValueMapper;
import org.dflib.ValueMapper;
import org.dflib.jdbc.connector.JdbcFunction;

@FunctionalInterface
public interface JdbcExtractorFactory<T> {
    public static Extractor<ResultSet, Boolean> $bool(int pos) {
        BoolValueMapper mapper = rs -> {
            try {
                return rs.getBoolean(pos);
            }
            catch (SQLException e) {
                throw new RuntimeException("Error performing SQL operation", e);
            }
        };
        return Extractor.$bool((BoolValueMapper)mapper);
    }

    public static Extractor<ResultSet, Integer> $int(int pos) {
        IntValueMapper mapper = rs -> {
            try {
                return rs.getInt(pos);
            }
            catch (SQLException e) {
                throw new RuntimeException("Error performing SQL operation", e);
            }
        };
        return Extractor.$int((IntValueMapper)mapper);
    }

    public static Extractor<ResultSet, Long> $long(int pos) {
        LongValueMapper mapper = rs -> {
            try {
                return rs.getLong(pos);
            }
            catch (SQLException e) {
                throw new RuntimeException("Error performing SQL operation", e);
            }
        };
        return Extractor.$long((LongValueMapper)mapper);
    }

    public static Extractor<ResultSet, Double> $double(int pos) {
        DoubleValueMapper mapper = rs -> {
            try {
                return rs.getDouble(pos);
            }
            catch (SQLException e) {
                throw new RuntimeException("Error performing SQL operation", e);
            }
        };
        return Extractor.$double((DoubleValueMapper)mapper);
    }

    public static Extractor<ResultSet, Object> $col(int pos) {
        return JdbcExtractorFactory.fromJdbcFunction(rs -> rs.getObject(pos));
    }

    public static Extractor<ResultSet, LocalDate> $date(int pos) {
        return JdbcExtractorFactory.fromJdbcFunction(rs -> {
            Date date = rs.getDate(pos);
            return date != null ? date.toLocalDate() : null;
        });
    }

    public static Extractor<ResultSet, LocalTime> $time(int pos) {
        return JdbcExtractorFactory.fromJdbcFunction(rs -> {
            Time time = rs.getTime(pos, Calendar.getInstance());
            return time != null ? time.toLocalTime() : null;
        });
    }

    public static Extractor<ResultSet, LocalDateTime> $datetime(int pos) {
        return JdbcExtractorFactory.fromJdbcFunction(rs -> {
            Timestamp timestamp = rs.getTimestamp(pos, Calendar.getInstance());
            return timestamp != null ? timestamp.toLocalDateTime() : null;
        });
    }

    public static <T> Extractor<ResultSet, T> fromJdbcFunction(JdbcFunction<ResultSet, T> f) {
        ValueMapper mapper = rs -> {
            try {
                return f.apply((ResultSet)rs);
            }
            catch (SQLException e) {
                throw new RuntimeException("Error performing SQL operation", e);
            }
        };
        return Extractor.$col((ValueMapper)mapper);
    }

    public Extractor<ResultSet, T> createExtractor(int var1);
}

