/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jdbc.connector.metadata;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.dflib.jdbc.connector.metadata.DbColumnMetadata;
import org.dflib.jdbc.connector.metadata.DbTableMetadata;
import org.dflib.jdbc.connector.metadata.TableFQName;
import org.dflib.jdbc.connector.metadata.flavors.DbFlavor;
import org.dflib.jdbc.connector.metadata.flavors.DbFlavorFactory;

public class DbMetadata {
    private DataSource dataSource;
    private DbFlavor flavor;
    private Map<TableFQName, DbTableMetadata> tables;

    protected DbMetadata(DataSource dataSource, DbFlavor flavor) {
        this.dataSource = dataSource;
        this.flavor = Objects.requireNonNull(flavor);
        this.tables = new ConcurrentHashMap<TableFQName, DbTableMetadata>();
    }

    public static DbMetadata create(DataSource dataSource) {
        DbFlavor flavor = DbFlavorFactory.create(dataSource);
        return new DbMetadata(dataSource, flavor);
    }

    public DbFlavor getFlavor() {
        return this.flavor;
    }

    public String getIdentifierQuote() {
        return this.flavor.getIdentifierQuote();
    }

    public boolean supportsParamsMetadata() {
        return this.flavor.supportsParamsMetadata();
    }

    public boolean supportsBatchUpdates() {
        return this.flavor.supportsBatchUpdates();
    }

    public boolean supportsCatalogs() {
        return this.flavor.supportsCatalogs();
    }

    public boolean supportsSchemas() {
        return this.flavor.supportsSchemas();
    }

    public DbTableMetadata getTable(String name) {
        TableFQName fqName = this.parseTableName(name);
        return this.tables.computeIfAbsent(fqName, this::loadTableMetadata);
    }

    public DbTableMetadata getTable(TableFQName tableName) {
        return this.tables.computeIfAbsent(tableName, this::loadTableMetadata);
    }

    public TableFQName parseTableName(String tableName) {
        String[] parts = tableName.split("\\.", 3);
        switch (parts.length) {
            case 1: {
                return new TableFQName(null, null, parts[0]);
            }
            case 2: {
                if (this.supportsSchemas()) {
                    return new TableFQName(null, parts[0], parts[1]);
                }
                if (this.supportsCatalogs()) {
                    return new TableFQName(parts[0], null, parts[1]);
                }
                return new TableFQName(null, null, tableName);
            }
            case 3: {
                if (this.supportsCatalogs() && this.supportsSchemas()) {
                    return new TableFQName(parts[0], parts[1], parts[2]);
                }
                return new TableFQName(null, null, tableName);
            }
        }
        return new TableFQName(null, null, tableName);
    }

    private DbTableMetadata loadTableMetadata(TableFQName tableName) {
        LinkedHashMap<String, Integer> columnsAndTypes = new LinkedHashMap<String, Integer>();
        HashSet<String> pks = new HashSet<String>();
        HashSet<String> nullable = new HashSet<String>();
        try (Connection c = this.dataSource.getConnection();){
            DatabaseMetaData md = c.getMetaData();
            try (ResultSet columnsRs = md.getColumns(tableName.getCatalog(), tableName.getSchema(), tableName.getTable(), null);){
                while (columnsRs.next()) {
                    String name = columnsRs.getString("COLUMN_NAME");
                    int type = this.flavor.columnType(columnsRs.getInt("DATA_TYPE"), columnsRs.getString("TYPE_NAME"));
                    columnsAndTypes.put(name, type);
                    if (!"YES".equals(columnsRs.getString("IS_NULLABLE"))) continue;
                    nullable.add(name);
                }
            }
            if (columnsAndTypes.isEmpty()) {
                try (ResultSet tablesRs = md.getTables(tableName.getCatalog(), tableName.getSchema(), tableName.getTable(), null);){
                    if (!tablesRs.next()) {
                        throw new RuntimeException("Non-existent table '" + tableName + "'");
                    }
                }
            }
            try (ResultSet pkRs = md.getPrimaryKeys(tableName.getCatalog(), tableName.getSchema(), tableName.getTable());){
                while (pkRs.next()) {
                    pks.add(pkRs.getString("COLUMN_NAME"));
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Error getting info about table '" + tableName + "'", e);
        }
        int len = columnsAndTypes.size();
        DbColumnMetadata[] columns = new DbColumnMetadata[len];
        int i = 0;
        for (Map.Entry e : columnsAndTypes.entrySet()) {
            String name = (String)e.getKey();
            columns[i++] = new DbColumnMetadata(name, (Integer)e.getValue(), pks.contains(name), nullable.contains(name));
        }
        return new DbTableMetadata(tableName, columns);
    }
}

