/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jdbc.connector.metadata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.dflib.jdbc.connector.metadata.DbColumnMetadata;
import org.dflib.jdbc.connector.metadata.TableFQName;

public class DbTableMetadata {
    private TableFQName name;
    private DbColumnMetadata[] columns;
    private Map<String, DbColumnMetadata> columnsByName;
    private DbColumnMetadata[] pk;

    public DbTableMetadata(TableFQName name, DbColumnMetadata[] columns) {
        this.name = name;
        this.columns = columns;
        this.columnsByName = new HashMap<String, DbColumnMetadata>();
        for (DbColumnMetadata column : columns) {
            DbColumnMetadata existing = this.columnsByName.put(column.getName(), column);
            if (existing == null || existing == column) continue;
            throw new IllegalArgumentException("Duplicate column name: " + column.getName());
        }
    }

    public TableFQName getName() {
        return this.name;
    }

    public DbColumnMetadata[] getColumns() {
        return this.columns;
    }

    public String[] getColumnNames() {
        String[] names = new String[this.columns.length];
        for (int i = 0; i < this.columns.length; ++i) {
            names[i] = this.columns[i].getName();
        }
        return names;
    }

    public DbColumnMetadata[] getPkColumns() {
        if (this.pk == null) {
            this.pk = this.findPk();
        }
        return this.pk;
    }

    public boolean hasColumn(String name) {
        return this.columnsByName.containsKey(name);
    }

    public DbColumnMetadata getColumn(String name) {
        DbColumnMetadata column = this.columnsByName.get(name);
        if (column == null) {
            throw new IllegalArgumentException("Column named '" + name + "' does not exist in table '" + this.name + "'");
        }
        return column;
    }

    private DbColumnMetadata[] findPk() {
        ArrayList<DbColumnMetadata> pk = new ArrayList<DbColumnMetadata>();
        for (DbColumnMetadata c : this.columns) {
            if (!c.isPk()) continue;
            pk.add(c);
        }
        return pk.toArray(new DbColumnMetadata[0]);
    }
}

