/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jdbc.connector.metadata;

import java.util.Objects;

public class TableFQName {
    private String catalog;
    private String schema;
    private String table;

    public TableFQName(String catalog, String schema, String table) {
        this.catalog = catalog != null && catalog.length() == 0 ? null : catalog;
        this.schema = schema != null && schema.length() == 0 ? null : schema;
        this.table = Objects.requireNonNull(table);
    }

    public static TableFQName forName(String tableName) {
        return new TableFQName(null, null, tableName);
    }

    public static TableFQName forSchemaAndName(String schema, String tableName) {
        return new TableFQName(null, schema, tableName);
    }

    public static TableFQName forCatalogAndName(String catalog, String tableName) {
        return new TableFQName(catalog, null, tableName);
    }

    public static TableFQName forCatalogSchemaAndName(String catalog, String schema, String tableName) {
        return new TableFQName(catalog, schema, tableName);
    }

    public boolean hasCatalog() {
        return this.catalog != null;
    }

    public boolean hasSchema() {
        return this.schema != null;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getTable() {
        return this.table;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TableFQName) {
            TableFQName ot = (TableFQName)o;
            return Objects.equals(this.catalog, ot.catalog) && Objects.equals(this.schema, ot.schema) && Objects.equals(this.table, ot.table);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.catalog, this.schema, this.table);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        if (this.catalog != null) {
            buffer.append(this.catalog).append(".");
        }
        if (this.schema != null) {
            buffer.append(this.schema).append(".");
        }
        buffer.append(this.table);
        return buffer.toString();
    }
}

