/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jdbc.connector.metadata.flavors;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.dflib.jdbc.connector.metadata.flavors.DbFlavor;
import org.dflib.jdbc.connector.metadata.flavors.DerbyFlavor;
import org.dflib.jdbc.connector.metadata.flavors.GenericFlavor;
import org.dflib.jdbc.connector.metadata.flavors.MySQLFlavor;
import org.dflib.jdbc.connector.metadata.flavors.PostgresFlavor;

public class DbFlavorFactory {
    public static DbFlavor create(DataSource dataSource) {
        DbFlavor dbFlavor;
        block8: {
            Connection c = dataSource.getConnection();
            try {
                DatabaseMetaData jdbcMd = c.getMetaData();
                dbFlavor = DbFlavorFactory.createFlavor(jdbcMd);
                if (c == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (c != null) {
                        try {
                            c.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new RuntimeException("Error connecting to DB or retrieving DB metadata");
                }
            }
            c.close();
        }
        return dbFlavor;
    }

    private static DbFlavor createFlavor(DatabaseMetaData metadata) throws SQLException {
        String dbName = metadata.getDatabaseProductName();
        if (dbName == null) {
            return GenericFlavor.create(metadata);
        }
        String dbNameUpper = dbName.toUpperCase();
        if (dbNameUpper.contains("MYSQL")) {
            return MySQLFlavor.create(metadata);
        }
        if (dbNameUpper.contains("MARIADB")) {
            return MySQLFlavor.create(metadata);
        }
        if (dbNameUpper.contains("APACHE DERBY")) {
            return DerbyFlavor.create(metadata);
        }
        if (dbNameUpper.contains("POSTGRESQL")) {
            return PostgresFlavor.create(metadata);
        }
        return GenericFlavor.create(metadata);
    }
}

