/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jdbc.connector.metadata.flavors;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.dflib.jdbc.connector.metadata.flavors.DbFlavor;

public class GenericFlavor
implements DbFlavor {
    protected boolean supportsCatalogs;
    protected boolean supportsSchemas;
    protected boolean supportsParamsMetadata;
    protected boolean supportsBatchUpdates;
    protected String identifierQuote;

    protected GenericFlavor() {
    }

    public static GenericFlavor create(DatabaseMetaData metaData) throws SQLException {
        GenericFlavor flavor = new GenericFlavor();
        flavor.supportsCatalogs = metaData.supportsCatalogsInTableDefinitions();
        flavor.supportsSchemas = metaData.supportsSchemasInTableDefinitions();
        flavor.supportsParamsMetadata = true;
        flavor.supportsBatchUpdates = metaData.supportsBatchUpdates();
        flavor.identifierQuote = metaData.getIdentifierQuoteString();
        return flavor;
    }

    @Override
    public String getIdentifierQuote() {
        return this.identifierQuote;
    }

    @Override
    public boolean supportsParamsMetadata() {
        return this.supportsParamsMetadata;
    }

    @Override
    public boolean supportsBatchUpdates() {
        return this.supportsBatchUpdates;
    }

    @Override
    public boolean supportsCatalogs() {
        return this.supportsCatalogs;
    }

    @Override
    public boolean supportsSchemas() {
        return this.supportsSchemas;
    }

    @Override
    public int columnType(int jdbcType, String nativeType) {
        return jdbcType;
    }
}

