/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jdbc.connector.saver;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.dflib.DataFrame;
import org.dflib.Index;
import org.dflib.Series;
import org.dflib.concat.SeriesConcat;
import org.dflib.jdbc.SaveOp;
import org.dflib.jdbc.connector.JdbcConnector;
import org.dflib.jdbc.connector.StatementBuilder;
import org.dflib.jdbc.connector.metadata.DbColumnMetadata;
import org.dflib.jdbc.connector.metadata.DbTableMetadata;
import org.dflib.jdbc.connector.metadata.TableFQName;
import org.dflib.jdbc.connector.tx.Tx;
import org.dflib.series.SingleValueSeries;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TableSaveStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(TableSaveStrategy.class);
    protected final JdbcConnector connector;
    protected final TableFQName tableName;
    private final int batchSize;

    public TableSaveStrategy(JdbcConnector connector, TableFQName tableName, int batchSize) {
        this.connector = connector;
        this.tableName = tableName;
        this.batchSize = batchSize;
    }

    public Supplier<Series<SaveOp>> save(DataFrame df) {
        boolean shouldDelete = this.shouldDelete(df);
        boolean shouldInsertOrUpdate = this.shouldInsertOrUpdate(df);
        if (!shouldDelete && !shouldInsertOrUpdate) {
            this.log("Nothing to save", new Object[0]);
            return () -> new SingleValueSeries((Object)SaveOp.skip, df.height());
        }
        return Tx.newTransaction(this.connector).call(c -> {
            if (shouldDelete) {
                this.doDelete((JdbcConnector)c, df);
            }
            if (!shouldInsertOrUpdate) {
                return () -> new SingleValueSeries((Object)SaveOp.skip, df.height());
            }
            if (this.batchSize <= 0) {
                return this.doInsertOrUpdate((JdbcConnector)c, df);
            }
            List<DataFrame> splits = this.split(df);
            ArrayList<Supplier<Series<SaveOp>>> results = new ArrayList<Supplier<Series<SaveOp>>>(splits.size());
            for (DataFrame sdf : splits) {
                results.add(this.doInsertOrUpdate((JdbcConnector)c, sdf));
            }
            return () -> SeriesConcat.concat((Iterable)results.stream().map(Supplier::get).collect(Collectors.toList()));
        });
    }

    protected List<DataFrame> split(DataFrame df) {
        int h = df.height();
        if (this.batchSize < 1 || this.batchSize >= h) {
            return List.of(df);
        }
        int fullSlots = h / this.batchSize;
        int partialSlotSize = h % this.batchSize;
        ArrayList<DataFrame> split = new ArrayList<DataFrame>(partialSlotSize > 0 ? fullSlots + 1 : fullSlots);
        for (int i = 0; i < fullSlots; ++i) {
            int start = i * this.batchSize;
            split.add(df.rowsRange(start, start + this.batchSize).select());
        }
        if (partialSlotSize > 0) {
            int start = fullSlots * this.batchSize;
            split.add(df.rowsRange(start, start + partialSlotSize).select());
        }
        return split;
    }

    protected boolean shouldDelete(DataFrame df) {
        return false;
    }

    protected boolean shouldInsertOrUpdate(DataFrame df) {
        return df.height() > 0;
    }

    protected abstract Supplier<Series<SaveOp>> doInsertOrUpdate(JdbcConnector var1, DataFrame var2);

    protected int doDelete(JdbcConnector connector, DataFrame df) {
        return -1;
    }

    protected int doInsert(JdbcConnector connector, DataFrame df) {
        StatementBuilder builder = connector.createStatementBuilder(this.createInsertStatement(df)).paramDescriptors(this.fixedParams(df.getColumnsIndex())).bindBatch(df);
        try (Connection c = connector.getConnection();){
            builder.update(c);
        }
        catch (SQLException e) {
            throw new RuntimeException("Error closing DB connection", e);
        }
        return df.height();
    }

    protected DbColumnMetadata[] fixedParams(Index index) {
        DbTableMetadata tableMetadata = this.connector.getMetadata().getTable(this.tableName);
        DbColumnMetadata[] params = new DbColumnMetadata[index.size()];
        for (int i = 0; i < index.size(); ++i) {
            params[i] = tableMetadata.getColumn(index.get(i));
        }
        return params;
    }

    protected void log(String line, Object ... messageParams) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(line, messageParams);
        }
    }

    private String createInsertStatement(DataFrame df) {
        int i;
        StringBuilder sql = new StringBuilder("insert into ").append(this.connector.quoteTableName(this.tableName)).append(" (");
        Index index = df.getColumnsIndex();
        int len = index.size();
        for (i = 0; i < len; ++i) {
            if (i > 0) {
                sql.append(", ");
            }
            sql.append(this.connector.quoteIdentifier(index.get(i)));
        }
        sql.append(") values (");
        for (i = 0; i < len; ++i) {
            if (i > 0) {
                sql.append(", ");
            }
            sql.append("?");
        }
        sql.append(")");
        return sql.toString();
    }
}

