/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jdbc.connector.saver;

import java.util.BitSet;
import org.dflib.Series;
import org.dflib.builder.ObjectAccum;
import org.dflib.jdbc.SaveOp;
import org.dflib.join.JoinIndicator;

class UpsertInfoTracker {
    private int width;
    private int height;
    private Series<JoinIndicator> newOldJoin;
    private Series<BitSet> updatePositions;

    public UpsertInfoTracker(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public Series<SaveOp> getInfo() {
        return this.updatePositions != null ? this.insertsUpdatesAndSkips() : this.insertsAndSkips();
    }

    private Series<SaveOp> insertsAndSkips() {
        ObjectAccum accum = new ObjectAccum(this.height);
        block4: for (int i = 0; i < this.height; ++i) {
            switch ((JoinIndicator)this.newOldJoin.get(i)) {
                case both: {
                    accum.push((Object)SaveOp.skip);
                    continue block4;
                }
                case left_only: {
                    accum.push((Object)SaveOp.insert);
                    continue block4;
                }
                default: {
                    throw new IllegalStateException("Unexpected join indicator: " + this.newOldJoin.get(i));
                }
            }
        }
        return accum.toSeries();
    }

    private Series<SaveOp> insertsUpdatesAndSkips() {
        ObjectAccum accum = new ObjectAccum(this.height);
        int updatePos = 0;
        block4: for (int i = 0; i < this.height; ++i) {
            switch ((JoinIndicator)this.newOldJoin.get(i)) {
                case both: {
                    int c = ((BitSet)this.updatePositions.get(updatePos)).cardinality();
                    accum.push((Object)(c == this.width ? SaveOp.skip : SaveOp.update));
                    ++updatePos;
                    continue block4;
                }
                case left_only: {
                    accum.push((Object)SaveOp.insert);
                    continue block4;
                }
                default: {
                    throw new IllegalStateException("Unexpected join indicator: " + this.newOldJoin.get(i));
                }
            }
        }
        return accum.toSeries();
    }

    public void insertAndUpdate(Series<JoinIndicator> newOldJoin) {
        this.newOldJoin = newOldJoin;
    }

    public void updatesCardinality(Series<BitSet> updatePositions) {
        this.updatePositions = updatePositions;
    }
}

