/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jdbc.connector.statement;

import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Calendar;
import org.dflib.jdbc.connector.statement.ColumnBinder;

public class ByJavaTypeColumnBinder
implements ColumnBinder {
    private static final int FAKE_JDBC_TYPE = 12;
    private PreparedStatement statement;
    private int position;

    public ByJavaTypeColumnBinder(PreparedStatement statement, int position) {
        this.statement = statement;
        this.position = position;
    }

    @Override
    public void bind(Object o) throws SQLException {
        Object boundable = this.normalize(o);
        if (boundable == null) {
            this.statement.setNull(this.position, 12);
        } else if (boundable instanceof byte[]) {
            this.statement.setBytes(this.position, (byte[])boundable);
        } else if (boundable instanceof Timestamp) {
            this.statement.setTimestamp(this.position, (Timestamp)boundable, Calendar.getInstance());
        } else if (boundable instanceof Time) {
            this.statement.setTime(this.position, (Time)boundable, Calendar.getInstance());
        } else {
            this.statement.setObject(this.position, boundable, 12);
        }
    }

    private Object normalize(Object o) {
        if (o == null) {
            return o;
        }
        if (o instanceof LocalDateTime) {
            return Timestamp.valueOf((LocalDateTime)o);
        }
        if (o instanceof LocalTime) {
            return Time.valueOf((LocalTime)o);
        }
        if (o instanceof LocalDate) {
            return Date.valueOf((LocalDate)o);
        }
        return o;
    }
}

