/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jdbc.connector.statement;

import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.dflib.jdbc.connector.metadata.flavors.DbFlavor;
import org.dflib.jdbc.connector.statement.ByJavaTypeColumnBinder;
import org.dflib.jdbc.connector.statement.ColumnBinder;
import org.dflib.jdbc.connector.statement.DefaultColumnBinder;
import org.dflib.jdbc.connector.statement.StatementBinder;
import org.dflib.jdbc.connector.statement.StatementBinderFactory;
import org.dflib.jdbc.connector.statement.ValueConverter;
import org.dflib.jdbc.connector.statement.ValueConverterFactory;

public class CompiledFromStatementBinderFactory
implements StatementBinderFactory {
    protected DbFlavor flavor;
    protected ValueConverterFactory converterFactory;

    public CompiledFromStatementBinderFactory(DbFlavor flavor, ValueConverterFactory converterFactory) {
        this.flavor = flavor;
        this.converterFactory = converterFactory;
    }

    @Override
    public StatementBinder createBinder(PreparedStatement statement) throws SQLException {
        ParameterMetaData pmd = statement.getParameterMetaData();
        int len = pmd.getParameterCount();
        ColumnBinder[] columnBinders = new ColumnBinder[len];
        for (int i = 0; i < len; ++i) {
            int jdbcPos = i + 1;
            if (this.flavor.supportsParamsMetadata()) {
                int jdbcType = this.flavor.columnType(pmd.getParameterType(jdbcPos), pmd.getParameterTypeName(jdbcPos));
                ValueConverter converter = this.converterFactory.findConverter(jdbcType);
                columnBinders[i] = new DefaultColumnBinder(statement, jdbcPos, jdbcType, converter);
                continue;
            }
            columnBinders[i] = new ByJavaTypeColumnBinder(statement, jdbcPos);
        }
        return new StatementBinder(columnBinders);
    }
}

