/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jdbc.connector.statement;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.dflib.jdbc.connector.statement.ColumnBinder;
import org.dflib.jdbc.connector.statement.ValueConverter;

public class DefaultColumnBinder
implements ColumnBinder {
    private PreparedStatement statement;
    private int type;
    private int position;
    private ValueConverter valueConverter;

    public DefaultColumnBinder(PreparedStatement statement, int position, int type, ValueConverter valueConverter) {
        this.statement = statement;
        this.type = type;
        this.position = position;
        this.valueConverter = valueConverter;
    }

    @Override
    public void bind(Object o) throws SQLException {
        Object boundable;
        Object object = boundable = o != null ? this.valueConverter.convert(o) : null;
        if (boundable == null) {
            this.statement.setNull(this.position, this.type);
        } else if (boundable instanceof byte[]) {
            this.statement.setBytes(this.position, (byte[])boundable);
        } else if (boundable instanceof Timestamp && this.type == 93) {
            this.statement.setTimestamp(this.position, (Timestamp)boundable, Calendar.getInstance());
        } else if (boundable instanceof Time && this.type == 92) {
            this.statement.setTime(this.position, (Time)boundable, Calendar.getInstance());
        } else {
            this.statement.setObject(this.position, boundable, this.type);
        }
    }
}

