/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jdbc.connector.statement;

import java.sql.PreparedStatement;
import org.dflib.jdbc.connector.metadata.DbColumnMetadata;
import org.dflib.jdbc.connector.statement.ColumnBinder;
import org.dflib.jdbc.connector.statement.DefaultColumnBinder;
import org.dflib.jdbc.connector.statement.StatementBinder;
import org.dflib.jdbc.connector.statement.StatementBinderFactory;
import org.dflib.jdbc.connector.statement.ValueConverterFactory;

public class FixedParamsBinderFactory
implements StatementBinderFactory {
    protected ValueConverterFactory converterFactory;
    private DbColumnMetadata[] paramDescriptors;

    public FixedParamsBinderFactory(ValueConverterFactory converterFactory, DbColumnMetadata[] paramDescriptors) {
        this.converterFactory = converterFactory;
        this.paramDescriptors = paramDescriptors;
    }

    @Override
    public StatementBinder createBinder(PreparedStatement statement) {
        int len = this.paramDescriptors.length;
        ColumnBinder[] columnBinders = new ColumnBinder[len];
        for (int i = 0; i < len; ++i) {
            int jdbcPos = i + 1;
            int jdbcType = this.paramDescriptors[i].getType();
            columnBinders[i] = new DefaultColumnBinder(statement, jdbcPos, jdbcType, this.converterFactory.findConverter(jdbcType));
        }
        return new StatementBinder(columnBinders);
    }
}

