/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jdbc.connector.statement;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.dflib.jdbc.connector.JdbcFunction;
import org.dflib.jdbc.connector.SqlLogger;
import org.dflib.jdbc.connector.statement.SelectStatement;

public class SelectStatementNoParams
implements SelectStatement {
    private String sql;
    private SqlLogger logger;

    public SelectStatementNoParams(String sql, SqlLogger logger) {
        this.logger = logger;
        this.sql = sql;
    }

    @Override
    public <T> T select(Connection connection, JdbcFunction<ResultSet, T> resultReader) throws SQLException {
        this.logger.log(this.sql);
        try (PreparedStatement ps = connection.prepareStatement(this.sql);){
            T t;
            block12: {
                ResultSet rs = ps.executeQuery();
                try {
                    t = resultReader.apply(rs);
                    if (rs == null) break block12;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return t;
        }
    }
}

