/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jdbc.connector.statement;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.dflib.Series;
import org.dflib.jdbc.connector.JdbcFunction;
import org.dflib.jdbc.connector.SqlLogger;
import org.dflib.jdbc.connector.statement.SelectStatement;
import org.dflib.jdbc.connector.statement.StatementBinderFactory;

public class SelectStatementWithParams
implements SelectStatement {
    private String sql;
    private Series<?> params;
    private StatementBinderFactory binderFactory;
    private SqlLogger logger;

    public SelectStatementWithParams(String sql, Series<?> params, StatementBinderFactory binderFactory, SqlLogger logger) {
        this.sql = sql;
        this.params = params;
        this.binderFactory = binderFactory;
        this.logger = logger;
    }

    @Override
    public <T> T select(Connection connection, JdbcFunction<ResultSet, T> resultReader) throws SQLException {
        this.logger.log(this.sql, this.params);
        try (PreparedStatement ps = connection.prepareStatement(this.sql);){
            T t;
            block12: {
                this.bind(ps);
                ResultSet rs = ps.executeQuery();
                try {
                    t = resultReader.apply(rs);
                    if (rs == null) break block12;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return t;
        }
    }

    private void bind(PreparedStatement statement) throws SQLException {
        if (this.params.size() > 0) {
            this.binderFactory.createBinder(statement).bind(this.params);
        }
    }
}

