/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jdbc.connector.statement;

import java.sql.SQLException;
import org.dflib.Series;
import org.dflib.jdbc.connector.statement.ColumnBinder;
import org.dflib.row.RowProxy;

public class StatementBinder {
    private ColumnBinder[] positions;

    public StatementBinder(ColumnBinder[] positions) {
        this.positions = positions;
    }

    public void bind(Series<?> values) throws SQLException {
        int len2;
        int len1 = this.positions != null ? this.positions.length : 0;
        int n = len2 = values != null ? values.size() : 0;
        if (len1 != len2) {
            throw new SQLException("Expected " + len1 + " bindings, got " + len2);
        }
        if (len1 > 0) {
            for (int i = 0; i < len1; ++i) {
                this.positions[i].bind(values.get(i));
            }
        }
    }

    public void bind(RowProxy values) throws SQLException {
        int len = this.positions != null ? this.positions.length : 0;
        for (int i = 0; i < len; ++i) {
            this.positions[i].bind(values.get(i));
        }
    }
}

