/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jdbc.connector.statement;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.dflib.DataFrame;
import org.dflib.jdbc.connector.SqlLogger;
import org.dflib.jdbc.connector.statement.StatementBinder;
import org.dflib.jdbc.connector.statement.StatementBinderFactory;
import org.dflib.jdbc.connector.statement.UpdateStatement;
import org.dflib.row.RowProxy;

public class UpdateStatementNoBatch
implements UpdateStatement {
    private String sql;
    private DataFrame paramsBatch;
    private StatementBinderFactory binderFactory;
    private SqlLogger logger;

    public UpdateStatementNoBatch(String sql, DataFrame paramsBatch, StatementBinderFactory binderFactory, SqlLogger logger) {
        this.sql = sql;
        this.paramsBatch = paramsBatch;
        this.binderFactory = binderFactory;
        this.logger = logger;
    }

    @Override
    public int[] update(Connection c) throws SQLException {
        this.logger.log(this.sql, this.paramsBatch);
        int len = this.paramsBatch.height();
        int[] updateCounts = new int[len];
        try (PreparedStatement st = c.prepareStatement(this.sql);){
            StatementBinder binder = this.binderFactory.createBinder(st);
            int i = 0;
            for (RowProxy row : this.paramsBatch) {
                binder.bind(row);
                updateCounts[i++] = st.executeUpdate();
            }
        }
        return updateCounts;
    }
}

