/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jdbc.connector.statement;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.dflib.Series;
import org.dflib.jdbc.connector.SqlLogger;
import org.dflib.jdbc.connector.statement.StatementBinderFactory;
import org.dflib.jdbc.connector.statement.UpdateStatement;

public class UpdateStatementParamsRow
implements UpdateStatement {
    private String sql;
    private Series<?> params;
    private StatementBinderFactory binderFactory;
    private SqlLogger logger;

    public UpdateStatementParamsRow(String sql, Series<?> params, StatementBinderFactory binderFactory, SqlLogger logger) {
        this.sql = sql;
        this.params = params;
        this.binderFactory = binderFactory;
        this.logger = logger;
    }

    @Override
    public int[] update(Connection c) throws SQLException {
        this.logger.log(this.sql, this.params);
        int[] updateCounts = new int[1];
        try (PreparedStatement st = c.prepareStatement(this.sql);){
            this.binderFactory.createBinder(st).bind(this.params);
            updateCounts[0] = st.executeUpdate();
        }
        return updateCounts;
    }
}

