/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.jdbc.connector.statement;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.Year;

public interface ValueConverter {
    public static ValueConverter defaultConverter() {
        return o -> o;
    }

    public static ValueConverter dateConverter() {
        return o -> o instanceof LocalDate ? Date.valueOf((LocalDate)o) : o;
    }

    public static ValueConverter timestampConverter() {
        return o -> o instanceof LocalDateTime ? Timestamp.valueOf((LocalDateTime)o) : o;
    }

    public static ValueConverter timeConverter() {
        return o -> o instanceof LocalTime ? Time.valueOf((LocalTime)o) : o;
    }

    public static ValueConverter intConverter() {
        return o -> {
            if (o instanceof Number) {
                return o;
            }
            if (o instanceof Month) {
                return ((Month)o).getValue();
            }
            if (o instanceof DayOfWeek) {
                return ((DayOfWeek)o).getValue();
            }
            if (o instanceof Enum) {
                return ((Enum)o).ordinal();
            }
            if (o instanceof Year) {
                return ((Year)o).getValue();
            }
            return o;
        };
    }

    public static ValueConverter stringConverter() {
        return o -> {
            if (o instanceof String) {
                return o;
            }
            if (o instanceof Enum) {
                return ((Enum)o).name();
            }
            return o;
        };
    }

    public Object convert(Object var1);
}

